%%%%%%%%%%%%%%%%%%%%% Error Reporting Structures _c "check" predicates

after_c(A,B,O) :- after_a(A,B), 
	format(O,"Error! ~w has been defined as being after ~w.~n", [A,B]).
before_c(A,B,O) :- before_a(A,B),
	format(O,"Error! ~w has been defined as being before ~w.~n", [A,B]).
meets_c(A,B,O) :- meets_a(A,B), 
	format(O,"Error! ~w has been defined as meeting ~w.~n", [A,B]).
met_by_c(A,B,O) :- met_by_a(A,B), 
	format(O,"Error! ~w has been defined as being met by ~w.~n", [A,B]).
overlaps_c(A,B,O) :- overlaps_a(A,B),
	format(O,"Error! ~w has been defined as overlapping ~w.~n", [A,B]).
overlapped_by_c(A,B,O) :- overlapped_by_a(A,B),
	format(O,"Error! ~w has been defined as being overlapped by ~w.~n", 
	[A,B]). 
starts_c(A,B,O) :- starts_a(A,B), 
	format(O,"Error! ~w has been defined as starting ~w.~n",[A,B]). 
started_by_c(A,B,O) :- started_by_a(A,B), 
	format(O,"Error! ~w has been defined as being started by ~w.~n",
	[A,B]). 
during_c(A,B,O) :- during_a(A,B),
	format(O,"Error! ~w has been defined as being during ~w.~n",[A,B]). 
contains_c(A,B,O) :- contains_a(A,B),  
	format(O,"Error! ~w has been defined as containing ~w.~n",[A,B]). 
finishes_c(A,B,O) :- finishes_a(A,B),
	format(O,"Error! ~w has been defined as finishing ~w.~n",[A,B]). 
finished_by_c(A,B,O) :- finished_by_a(A,B),
	format(O,"Error! ~w has been defined as being finished by ~w.~n",
	[A,B]). 
equal_c(A,B,O) :- equal_a(A,B), 
	format(O,"Error! ~w has been defined as being equal to ~w.~n",[A,B]). 

%%%%%%%%%%%%%%%%%%%%% Error Explanation Structures - explain predicates

explain(b_a,A,ArelB,B,BrelC,C,O) :-
        standard_explain(A,ArelB,B,BrelC,C,O,' can only be before ').
explain(bi_a,A,ArelB,B,BrelC,C,O) :- 
        standard_explain(A,ArelB,B,BrelC,C,O,' can only be after ').
explain(bomds_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be before, overlapping, meeting, starting, or during '). 
explain(bioimidf_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be after, overlapped by, met by, during, or finishing '). 
explain(boimidf_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be before, overlapped by, met by, during, or finishing '). 
explain(d_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,' can only be during '). 
explain(bomdifi_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be before, overlapping, meeting, containing, \c
          or finished by '). 
explain(bioidimisi_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be after, overlapped by, containing, met by, \c
          or started by ').
explain(ooiddie_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be overlapping, overlapped by, during, containing, \c
          or equal to ').
explain(di_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be containing ').
explain(oidifi_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be overlapped by, containing, or finished by ').
explain(oidisi_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be overlapped by, containing, or started by ').
explain(odifi_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be overlapping, containing, or finished by ').
explain(ods_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be ovelapping, during, or starting ').
explain(bom_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be before, overlapping, or meeting ').
explain(o_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be overlapping ').
explain(dso_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be during, starting, or overlapping ').
explain(oidf_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be overlapped by, during, or finishing ').
explain(bioimi_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be after, overlapped by, or met by ').
explain(oi_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be overlapped by ').
explain(ffie_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be finishing, finished by, or equal to ').
explain(m_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be meeting ').
explain(bioi_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be after or overlapped by ').
explain(ssie_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be starting, started by, or equal to ').
explain(mi_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be met by ').
explain(mib_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be met by or before ').
explain(df_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be during or finishing ').
explain(si_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be started by ').
explain(f_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be finishing ').
explain(e_a,A,ArelB,B,BrelC,C,O) :- 
	standard_explain(A,ArelB,B,BrelC,C,O,
	' can only be equal to ').
standard_explain(A,ArelB,B,BrelC,C,O,Alts) :-
        assert(problem_noted([A,B,C])),
        format(O, "If ~w is ~w ~w and ~w is ~w ~w then ~w~w~w.~n--~n", 
	[A,ArelB,B,B,BrelC,C,A,Alts,C]),
        flush_output(O).



