;;; Domain: three_pigs_building

;;; Common Process Translator CPL<-->TF v2.3
;;; Author: Steve Polyak, Dept. AI, Edinburgh University
;;; Task Formalism generated on: Fri Sep 25 11:11:34 GMT+01:00 1998

types capital = ( money),
      material = ( bricks sticks straw);

always {proof_against wolf bricks}=true;

resource_units pounds = count;

resource_types
  consumable_strictly {resource money} = pounds,
  consumable_strictly {resource bricks},
  consumable_strictly {resource sticks},
  consumable_strictly {resource straw};

task Build_House_Plan;
  nodes 2 finish,
        1 start,
        3 action {build_required_house};
  orderings end_of 1 ---> begin_of 3, end_of 3 ---> begin_of 2;

end_task;


schema Wall_Builder;
  vars ?material = ?{type material};
  expands {build_walls ?material};
  nodes 1 action {purchase ?material},
        2 action {make_walls_from ?material};
  orderings end_of 1 ---> begin_of 2;
  conditions supervised {have ?material} at 2 from [ 1 ];

end_schema;

schema House_Builder;
  vars ?material = ?{type material};
  expands {build_house_of ?material};
  nodes 1 action {build_walls ?material},
        2 action {install windows},
        3 action {install door};
  orderings end_of 1 ---> begin_of 3, end_of 1 ---> begin_of 2;
  conditions supervised {walls built} at 2 from [ 1 ],
             supervised {walls built} at 3 from [ 1 ];

end_schema;

schema Install_Windows;
  expands {install windows};
  only_use_for_effects {windows installed} = true;
  resources consumes {resource money} = 50 pounds;

end_schema;

schema Install_Wolf_Proof_Windows;
  expands {install windows};
  only_use_for_effects {windows installed} = true,
                       {wolf_proof windows} = true;
  resources consumes {resource money} = 100 pounds;

end_schema;

schema Install_Door;
  expands {install door};
  only_use_for_effects {door installed} = true;
  resources consumes {resource money} = 50 pounds;

end_schema;

schema Install_Wolf_Proof_Door;
  expands {install door};
  only_use_for_effects {door installed}=true,
                       {wolf_proof door} = true;
  resources consumes {resource money} = 100 pounds;

end_schema;

schema Make_Brick_Walls;
  expands {make_walls_from bricks};
  only_use_for_effects {walls built}=true,
                       {material wall} = bricks;
  resources consumes {resource money} = 500 pounds;

end_schema;

schema Make_Stick_Walls;
  expands {make_walls_from sticks};
  only_use_for_effects {walls built}=true,
                       {material wall} = sticks;
  resources consumes {resource money} = 200 pounds;

end_schema;

schema Make_Straw_Walls;
  expands {make_walls_from straw};
  only_use_for_effects {walls built}=true,
                       {material wall}=straw;
  resources consumes {resource money} = 100 pounds;

end_schema;

schema Purchase_Bricks;
  expands {purchase bricks};
  only_use_for_effects {have bricks};
  resources consumes {resource money} = 1000 pounds,
            consumes {resource bricks} = 1000;

end_schema;

schema Purchase_Sticks;
  expands {purchase sticks};
  only_use_for_effects {have sticks};
  resources consumes {resource money} = 200 pounds,
            consumes {resource sticks} = 1000;

end_schema;

schema Purchase_Straw;
  expands {purchase straw};
  only_use_for_effects {have straw};
  resources consumes {resource money} = 100 pounds,
            consumes {resource straw} = 1000;

end_schema;

schema Build_Secure_House;
  expands {build_required_house};
  nodes 1 action {check_security},
        2 action {build_house};
  orderings end_of 2 ---> begin_of 1;

end_schema;

schema Build_Basic_House;
  expands {build_required_house};
  nodes 1 action {build_house};

end_schema;

schema Build_House_of_Bricks;
  expands {build_house};
  nodes 1 action {build_house_of bricks};

end_schema;

schema Build_House_of_Sticks;
  expands {build_house};
  nodes 1 action {build_house_of sticks};

end_schema;

schema Build_House_of_Straw;
  expands {build_house};
  nodes 1 action {build_house_of straw};

end_schema;

schema Security_Checker;
  local_vars ?material = ?{type material};
  expands {check_security};
  conditions unsupervised {proof_against wolf ?material},
             unsupervised {material wall} = ?material,
             unsupervised {wolf_proof door},
             unsupervised {wolf_proof windows};

end_schema;

