/*
 * @(#)CpeRationPanel.java	1.0 98/4/28
 * 
 */

import com.sun.java.swing.*;
import java.awt.*;
import java.util.*;
import java.net.*;
import java.awt.event.*;
import CpeMainPanel;
import CpeRatTextPropertyDialog;

/**
 * CpeRationPanel is the content panel that sits in the CpeScrollPane
 * window. The scroll pane provides a viewport onto this panel.
 *
 * @version 1.0 98/4/28
 * @author Steve Polyak 
 */
public class CpeRationPanel extends JPanel implements MouseMotionListener,
  MouseListener, ActionListener 
{
  public CpeMainPanel mainPanel;
  public JInternalFrame frame;
  public CpeNode m_hitNode = null;
  public CpeRatTextPropertyDialog textDlg = null;
  public String m_userName = null;
  public String m_password = null;
  public String m_slot = null;
  public CpeRation process;
  public final int WIDTH = 800;
  public final int HEIGHT = 800;
  
  CpeRationPanel (CpeMainPanel mainPanel, boolean top) {
    super();
    super.addMouseMotionListener((MouseMotionListener)this);
    super.addMouseListener((MouseListener)this);
    
    this.mainPanel = mainPanel;
    setOpaque(false);
    process = new CpeRation(this, top);
    process.newProcess(); 
    //top-level process instances are reported to cpe for use
    //in save/open dialogs
    if (top);
    //IMPORTANT - here is the add back call
    //Cpe.sharedInstance().addProcess(this);
  }

  public synchronized void paintComponent(Graphics g) {
    process.update(g);
  }
  
  public Dimension getPreferredSize() {
    return new Dimension(WIDTH, HEIGHT);
  }
  
  public void mouseMoved(MouseEvent e) {
    process.mouseMove(e);
  }
  
  public void mouseDragged(MouseEvent e) {
    process.mouseDrag(e);
  }

  public void mouseClicked(MouseEvent e) {
    if (e.getClickCount() == 2) {
      //System.out.println("my listen double clicked");
    }
  }
  
  public void mouseEntered(MouseEvent e) {
  }
    
  public void mouseExited(MouseEvent e) {
  }
    
  public void mousePressed(MouseEvent e) {
    process.mouseDown(e);       
  }
  
  public void mouseReleased(MouseEvent e) {
    process.mouseUp(e);
  }
  
  public void actionPerformed(ActionEvent event){
    String command = event.getActionCommand();
    
    if(command.equals("newact")) process.addActivity();
    else if (command.equals("newdummy")) process.addDummy();
    else if (command.equals("newquestion")) process.addQuestion();
    else if (command.equals("delsel")) process.removeSelected();
    else if (command.equals("delnode")) process.removeNode(m_hitNode);
    else if (command.equals("addlink")) process.addLink(m_hitNode, false);
    else if (command.equals("addeqlink")) process.addEqLink(m_hitNode, false);
    else if (command.equals("addexp")) process.addExpansion(m_hitNode);
    else if (command.equals("delexp")) process.delExpansion(m_hitNode);
    else if (command.equals("showexp")) process.showExpansion(m_hitNode);
    else if (command.equals("addtext")) addText();
    else if (command.equals("procprop")) 
      process.showProcessPropertyDialog();
    else if (command.equals("nodeprop")) process.showNodePropertyDialog();
  }
  
  public void toolbarActionPerformed(ActionEvent event){
    String command = event.getActionCommand();
    
    if(command.equals("newquestion")) {
      process.popupPoint = new Point(20,20);
      process.addQuestion();
    }
    else if (command.equals("newoption")) {
      process.popupPoint = new Point(20,20);
      process.addOption();
    }
    else if (command.equals("newcriteria")) {
      process.popupPoint = new Point(20,20);
      process.addCriteria();
    }
    else if (command.equals("newtext")) {
      process.popupPoint = new Point(20,20);
      addText();
    }
    else if (command.equals("newlink")) process.requestLink();
    else if (command.equals("newpositive")) process.requestPos();
    else if (command.equals("newnegative")) process.requestNeg();
    else if (command.equals("cut")) process.removeSelected();
    else if (command.equals("copy")) process.copySelected();
    else if (command.equals("paste")) process.pasteSelected();
    else if (command.equals("aligntop")) process.alignTop();
    else if (command.equals("alignbottom")) process.alignBottom();
    else if (command.equals("alignleft")) process.alignLeft();
    else if (command.equals("alignright")) process.alignRight();
    else if (command.equals("aligncenter")) process.alignCenter();
    else if (command.equals("expand")) process.requestExpansion();
    else if (command.equals("up")) process.requestUp();
    else if (command.equals("newequal")) process.requestNewEqual();
    else if (command.equals("properties")) process.requestProperties();
    repaint();
  }

  public void addText() {
    if (textDlg == null) {
      textDlg = new CpeRatTextPropertyDialog(this, "Add text");
    }
    textDlg.setLocation(Cpe.sharedInstance().getCenteringPoint(textDlg));
    textDlg.show();
  }
}
