/*
 * @(#)CpeNodeRef.java	1.0 98/1/5
 * 
 */

import java.util.*;
import java.awt.*;

/**
 * CpeNodeRef is used to indicate ordering which cross expansions.
 *
 * @version 1.0 98/9/25
 * @author Steve Polyak 
 */
class CpeNodeRef extends CpeNode {
  
  
  CpeNodeRef(String key,int x, int y) {
    super(key,x,y);
  }
  
  public void drawFill(Graphics g, int x, int y, int width, int height) {
    g.fillRect(x, y, width, height);
    Polygon p = new Polygon();
    p.addPoint(x+width,y);
    p.addPoint(x+width,y+height);
    p.addPoint(x+width+6,(y+y+height)/2);
    g.fillPolygon(p);
  }
  
  public void drawShadow(Graphics g, int x, int y, int width, int height) {
    g.fillRect(x, y, width, height);
  }
  
  public void drawOutline(Graphics g, int x, int y, int width, int height) {
    g.drawRect(x, y, width, height);
    Polygon p = new Polygon();
    p.addPoint(x+width,y);
    p.addPoint(x+width,y+height);
    p.addPoint(x+width+6,(y+y+height)/2);
    g.drawPolygon(p);
  }

}
