import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import CpeDomainPane;
import CpeTreeItem;

public class CpeTypesRoot extends CpeTreeItem
{

  CpeTypesRoot(String label) {
    super(label);
    collapsedIcon = "images/collapsed.gif";
    expandedIcon = "images/expanded.gif";
  }

  public JPopupMenu createPopup(CpeDomainPane pane) {
    int ibegin, iend;
    String[] labels = new String[] { 
      "Add Type"};
      
    String[] commands = new String[] {
      "addtype"};
      
    JPopupMenu popup = new JPopupMenu();
    ibegin = 0;
    iend = 0;
      
    for(int i=ibegin; i <= iend; i++) {
      if (labels[i].equals("-")) {
	popup.addSeparator();
      }
      else {
	JMenuItem mi = new JMenuItem(labels[i]);
	mi.setActionCommand(commands[i]);
	mi.addActionListener(pane);
	popup.add(mi);
      }
    }
    return popup;
  }


  public void writeOut(FtpModule ftp, DefaultMutableTreeNode node) {

    DefaultMutableTreeNode childNode;
    CpeTypeItem item;

    //first determine how many types there are.
    int typeCount = node.getChildCount();

    if (typeCount > 0) {

      for  (Enumeration e = node.children(); e.hasMoreElements();){
	childNode = (DefaultMutableTreeNode) e.nextElement();
	item = (CpeTypeItem) childNode.getUserObject();
	//all top-level types inherit from ARO
	ftp.writeRemoteFile("entity.isa(\"cpo-object-"+item.label+
			    "\",\"cpo-activity-relatable-object\")");
	item.writeOut(ftp,childNode);
      }
    }
  }
    
}

