import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import CpeDomainPane;
import CpeTreeItem;

public class CpeTypeItem extends CpeTreeItem
{

  public DefaultMutableTreeNode node = null;

  CpeTypeItem(String label) {
    super(label);
  }

  public JPopupMenu createPopup(CpeDomainPane pane) {
    String[] labels = new String[] { 
      "Add Instance", "Add Subtype", "Delete","-", "Properties"};
      
    String[] commands = new String[] {
      "addinst", "addsub", "delete", "-", "prop"};
      
    JPopupMenu popup = new JPopupMenu();
      
    for(int i=0; i <= 4; i++) {
      if (labels[i].equals("-")) {
	popup.addSeparator();
      }
      else {
	JMenuItem mi = new JMenuItem(labels[i]);
	mi.setActionCommand(commands[i]);
	mi.addActionListener(pane);
	popup.add(mi);
      }
    }
    return popup;
  }


  public void writeOut(FtpModule ftp, DefaultMutableTreeNode node) {

    String instString = "";
    DefaultMutableTreeNode childNode;
    CpeTreeItem item;
    int instCount = 0;

    //first determine how many subitems there are.
    int childCount = node.getChildCount();

    if (childCount > 0) {

      for  (Enumeration e = node.children(); e.hasMoreElements();){
	childNode = (DefaultMutableTreeNode) e.nextElement();

	item = (CpeTreeItem) childNode.getUserObject();

	if ("CpeInstanceItem".equals(item.getClass().getName())) {
	  if (instCount==0)
	    instString = item.key;
	  else
	    instString = instString + "," + item.key;
	  instCount++;
	  ftp.writeFunctionStr("object.name",item.key, item.label);
	  item.writeOut(ftp,childNode);
	}
	else {
	  ftp.writeRemoteFile("entity.isa(\"cpo-object-" +
			      item.label
			      + "\",\"cpo-object-" +label
			      +"\")");
	  item.writeOut(ftp,childNode);
	}
      }
      if (instCount > 0) {
	ftp.writeRemoteFile("SORT cpo-object-\""+
			    label+"\"={" + instString + "}");
      }
    }
  }
    
}

