/*
 * @(#)CpeTreeModel.java	1.0 98/09/23
 *
 */

import com.sun.java.swing.tree.DefaultTreeModel;
import com.sun.java.swing.tree.TreeNode;
import com.sun.java.swing.tree.TreePath;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import java.awt.Color;
import java.awt.Dimension;

/**
  * CpeTreeModel extends JTreeModel to extends valueForPathChanged.
  * This method is called as a result of the user editing a value in
  * the tree.  If you allow editing in your tree, are using TreeNodes
  * and the user object of the TreeNodes is not a String, then you're going
  * to have to subclass JTreeModel as this example does.
  *
  * @version 1.0 09/23/98
  * @author Steve Polyak
  */

public class CpeTreeModel extends DefaultTreeModel
{
  /**
   * Creates a new instance of CpeTreeModel with newRoot set
   * to the root of this model.
   */
  public CpeTreeModel(TreeNode newRoot) {
    super(newRoot);
  }

  /**
   * Subclassed to message setString() to the changed path item.
   */
  public void valueForPathChanged(TreePath path, Object newValue) {
    /* Update the user object. */
    DefaultMutableTreeNode aNode = 
      (DefaultMutableTreeNode)path.getLastPathComponent();
    CpeTreeItem    item = (CpeTreeItem)aNode.getUserObject();
    
    item.label = (String)newValue;

    /* Since we've changed how the data is to be displayed, message
       nodeChanged. */
    nodeChanged(aNode);
    reload();
  }

}
