/*
 * @(#)CpeScrollPane.java	1.0 98/1/5
 */

import com.sun.java.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.*;
import java.net.*;

/**
 * CpeScrollPane provides a scrollable viewport onto the
 * CpeProcessPanel. 
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak
 */
class CpeScrollPane extends JScrollPane {
  public CpeMainPanel mainPanel;
  public CpeProcessPanel panel;
  
  public CpeScrollPane(CpeMainPanel mainPanel, int layer, boolean top) {
    super();
    this.mainPanel = mainPanel;
    
    JPanel p = new JPanel();
    p.setSize(800,800);
    p.setOpaque(false);
    p.setLayout(new BorderLayout() );
    
    panel = new CpeProcessPanel(mainPanel, top);
    panel.setOpaque(false);
    
    p.add(panel, BorderLayout.CENTER);
    
    getViewport().add(p);
  }
    
  public Dimension getMinimumSize() {
    return new Dimension(25, 25);
  }
  
  public boolean isOpaque() {
    return true;
  }
}
