/*
 * @(#)CpeRationPane.java	1.0 98/4/28
 * 
 */

import java.awt.*;
import java.util.*;
import CpeMainPanel;
import CpeRationScrollPane;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import java.awt.event.*;

/**
 * CpeRationPane holds a toolbar and scroll pane
 *
 * @version 1.0 98/4/28
 * @author Steve Polyak 
 */
public class CpeRationPane extends JPanel {
  CpeRationScrollPane scroll;
  JToolBar toolBar;
  Dialog aboutBox;

  public CpeRationPane(CpeMainPanel mainPanel, int layer, boolean top) {

    setLayout(new BorderLayout());
    toolBar = new JToolBar();
    addTool(toolBar, "newquestion");
    addTool(toolBar, "newoption");
    addTool(toolBar, "newcriteria");
    addTool(toolBar, "newtext");
    toolBar.addSeparator();
    addTool(toolBar, "newlink");
    addTool(toolBar, "newpositive");
    addTool(toolBar, "newnegative");
    addTool(toolBar, "properties");
    toolBar.addSeparator();
    addTool(toolBar, "cut");
    addTool(toolBar, "copy");
    addTool(toolBar, "paste");
    toolBar.addSeparator();
    addTool(toolBar, "aligntop");
    addTool(toolBar, "alignbottom");
    addTool(toolBar, "alignleft");
    addTool(toolBar, "alignright");
    addTool(toolBar, "aligncenter");
    add(toolBar, BorderLayout.NORTH);

    scroll = new CpeRationScrollPane(mainPanel, layer, top);
    add(scroll, BorderLayout.CENTER);
  }

  public void addTool(JToolBar toolBar, String name) {
    JButton b = 
      (JButton) toolBar.add
      (new JButton(Cpe.sharedInstance().loadImageIcon("images/" +
						      name +
						      ".gif",name)));
    b.setToolTipText(name);
    b.setActionCommand(name);
    b.setMargin(new Insets(0,0,0,0));
    
    //for all of the toolbar commands, we will pass them along to a
    //special process panel method.
    b.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	scroll.panel.toolbarActionPerformed(e);
      }
    });
  }
}
