/*
 * @(#)CpeRatProcPropertyDialog.java	1.0 98/1/5
 * 
 */

import java.awt.event.*;
import java.util.*;
import CpeProcessPanel;
import Cpe;
import com.sun.java.swing.*;
import java.awt.*;

/**
 * CpeRatProcPropertyDialog is used to display/set properties of the
 * process network.
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak 
 */
public class CpeRatProcPropertyDialog extends JDialog {
  protected Button btnOK;
  protected Button btnCancel;
  protected TextField txtName = null;
  protected TextField expands = null;
  protected CpeRationPanel m_panel = null;
  protected String m_oldText = "";
  protected String m_oldKey = "";
  protected ButtonGroup group;
  protected JTabbedPane tab;

  protected TextField reqInput;
  protected DefaultListModel reqList;
  protected TextField prefInput;
  protected DefaultListModel prefList;
  protected TextField varInput;
  protected DefaultListModel varList;
  protected TextField condInput;
  protected DefaultListModel condList;
  protected TextField effInput;
  protected DefaultListModel effList;
  protected TextField resInput;
  protected DefaultListModel resList;

  CpeRatProcPropertyDialog(CpeRationPanel parent, String title) {
    // Create a dialog with the specified title
    super(Cpe.sharedInstance().getFrame(), title, false);
    m_panel = parent;

    tab = new JTabbedPane();
    
    //    this.setLayout(new BorderLayout(25,5));
    this.getContentPane().setLayout(new BorderLayout(25,5));
    Panel fields = new Panel();
    fields.setLayout(new GridLayout(3,2));
    fields.add (new Label("Process Name:"));
    m_oldText = m_panel.process.label;
    m_oldKey = m_panel.process.key;
    txtName = new TextField(m_oldText);
    fields.add (txtName);

    fields.add (new Label("Expands:"));
    expands = new TextField();
    fields.add (expands);

    //bounding nodes gui
    fields.add (new Label("Bounding Nodes:"));
    Panel radioPanel = new Panel();
    radioPanel.setLayout(new GridLayout(1,2));
    group = new ButtonGroup();
    JRadioButton button;
    button = new JRadioButton("Start-Finish", true);
    button.setActionCommand("sf");
    group.add(button);
    radioPanel.add (button);
    button = new JRadioButton("Begin-End", false);
    button.setActionCommand("be");
    group.add(button);
    radioPanel.add(button);
    fields.add (radioPanel);

    tab.addTab("General",null,fields);


    //requirements gui
    Panel reqPanel = new Panel();
    reqPanel.setLayout(new BorderLayout(25,5));
    Panel reqPanel1 = new Panel();
    reqPanel1.setLayout(new GridLayout(2,1));
    reqInput = new TextField();
    reqPanel1.add(reqInput);
    reqList = new DefaultListModel();
    reqPanel1.add(new JScrollPane
		  (new JList(reqList), 
		   ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
		   ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    reqPanel.add("Center",reqPanel1);

    Panel reqPanel2 = new Panel();
    JButton addRBtn = new JButton("Add");
    addRBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	reqList.addElement(reqInput.getText());
	reqInput.setText("");
      }
    });
    reqPanel2.add(addRBtn);
    JButton delRBtn = new JButton("Delete");
    delRBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	reqList.removeAllElements();
      }
    });
    reqPanel2.add(delRBtn);
    reqPanel.add("South",reqPanel2);
    tab.addTab("Requirements",null,reqPanel);

    //preferences gui
    Panel prefPanel = new Panel();
    prefPanel.setLayout(new BorderLayout(25,5));
    Panel prefPanel1 = new Panel();
    prefPanel1.setLayout(new GridLayout(2,1));
    prefInput = new TextField();
    prefPanel1.add(prefInput);
    prefList = new DefaultListModel();
    prefPanel1.add(new JScrollPane
		   (new JList(prefList), 
		    ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, 
		    ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    prefPanel.add("Center",prefPanel1);

    Panel prefPanel2 = new Panel();
    JButton addPBtn = new JButton("Add");
    addPBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	prefList.addElement(prefInput.getText());
	prefInput.setText("");
      }
    });
    prefPanel2.add(addPBtn);
    JButton delPBtn = new JButton("Delete");
    delPBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	prefList.removeAllElements();
      }
    });
    prefPanel2.add(delPBtn);
    prefPanel.add("South",prefPanel2);
    tab.addTab("Preferences",null,prefPanel);

    //variables gui
    Panel varPanel = new Panel();
    varPanel.setLayout(new BorderLayout(25,5));
    Panel varPanel1 = new Panel();
    varPanel1.setLayout(new GridLayout(2,1));
    varInput = new TextField();
    varPanel1.add(varInput);
    varList = new DefaultListModel();
    varPanel1.add(new JScrollPane
		  (new JList(varList), 
		   ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, 
		   ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    varPanel.add("Center",varPanel1);

    Panel varPanel2 = new Panel();
    JButton addVBtn = new JButton("Add");
    addVBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	varList.addElement(varInput.getText());
	varInput.setText("");
      }
    });
    varPanel2.add(addVBtn);
    JButton delVBtn = new JButton("Delete");
    delVBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	varList.removeAllElements();
      }
    });
    varPanel2.add(delVBtn);
    varPanel.add("South",varPanel2);
    tab.addTab("Variables",null,varPanel);

    //resources gui
    Panel resPanel = new Panel();
    resPanel.setLayout(new BorderLayout(25,5));
    Panel resPanel1 = new Panel();
    resPanel1.setLayout(new GridLayout(2,1));
    resInput = new TextField();
    resPanel1.add(resInput);
    resList = new DefaultListModel();
    resPanel1.add(new JScrollPane
		  (new JList(resList), 
		   ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, 
		   ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    resPanel.add("Center",resPanel1);

    Panel resPanel2 = new Panel();
    JButton addRsBtn = new JButton("Add");
    addRsBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	resList.addElement(resInput.getText());
	resInput.setText("");
      }
    });
    resPanel2.add(addRsBtn);
    JButton delRsBtn = new JButton("Delete");
    delRsBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	resList.removeAllElements();
      }
    });
    resPanel2.add(delRsBtn);
    resPanel.add("South",resPanel2);
    tab.addTab("Resources",null,resPanel);

    //conditions gui
    Panel condPanel = new Panel();
    condPanel.setLayout(new BorderLayout(25,5));
    Panel condPanel1 = new Panel();
    condPanel1.setLayout(new GridLayout(2,1));
    condInput = new TextField();
    condPanel1.add(condInput);
    condList = new DefaultListModel();
    condPanel1.add(new JScrollPane
		   (new JList(condList), 
		    ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, 
		    ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    condPanel.add("Center",condPanel1);

    Panel condPanel2 = new Panel();
    JButton addCBtn = new JButton("Add");
    addCBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	condList.addElement(condInput.getText());
	condInput.setText("");
      }
    });
    condPanel2.add(addCBtn);
    JButton delCBtn = new JButton("Delete");
    delCBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	condList.removeAllElements();
      }
    });
    condPanel2.add(delCBtn);
    condPanel.add("South",condPanel2);
    tab.addTab("Conditions",null,condPanel);


    //effects gui
    Panel effPanel = new Panel();
    effPanel.setLayout(new BorderLayout(25,5));
    Panel effPanel1 = new Panel();
    effPanel1.setLayout(new GridLayout(2,1));
    effInput = new TextField();
    effPanel1.add(effInput);
    effList = new DefaultListModel();
    effPanel1.add(new JScrollPane
		  (new JList(effList), 
		   ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, 
		   ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    effPanel.add("Center",effPanel1);

    Panel effPanel2 = new Panel();
    JButton addEBtn = new JButton("Add");
    addEBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	effList.addElement(effInput.getText());
	effInput.setText("");
      }
    });
    effPanel2.add(addEBtn);
    JButton delEBtn = new JButton("Delete");
    delEBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	effList.removeAllElements();
      }
    });
    effPanel2.add(delEBtn);
    effPanel.add("South",effPanel2);
    tab.addTab("Effects",null,effPanel);

    this.getContentPane().add("Center",tab);
    
    Panel yn = new Panel();
    btnOK = new Button("OK");
    yn.add (btnOK);
    btnCancel = new Button("Cancel");
    yn.add (btnCancel);
    this.getContentPane().add ("South",yn);
    
    importLists();

    // Resize the window to the preferred size of its components
    //this.pack();
    this.setBounds(0,0,385,290);
  }
  
  // Pop down the window when the button is clicked.
  public boolean action(Event e, Object arg) {
    
    if("Cancel".equals(arg) == false) {
      //update value as long as cancel wasn't pressed.
      String tempString = txtName.getText();
      m_panel.process.setLabel(tempString);

      if (group.getSelection().getActionCommand().equals("sf")) {
	m_panel.process.setStartFinishFlag(true);
      } else {
	m_panel.process.setStartFinishFlag(false);
      }

      updateLists();
    }
    this.hide();
    this.dispose();
    m_panel.process.m_sheet = null;
    m_panel.repaint();
    
    return true;
  }

  private void updateLists() {
    String s = new String();
    for  (Enumeration e =  reqList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement();
      m_panel.process.requirements.addElement(s); }
    for  (Enumeration e =  prefList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); 
      m_panel.process.preferences.addElement(s); }
    for  (Enumeration e =  varList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); 
      m_panel.process.variables.addElement(s); }
    for  (Enumeration e =  condList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); 
      m_panel.process.preconditions.addElement(s); }
    for  (Enumeration e =  effList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); 
      m_panel.process.effects.addElement(s); }
    for  (Enumeration e =  resList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); 
      m_panel.process.resources.addElement(s); }
  }

  private void importLists() {
    String s = new String();
    for  (Enumeration e =  m_panel.process.requirements.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); reqList.addElement(s); }
    for  (Enumeration e =  m_panel.process.preferences.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); prefList.addElement(s); }
    for  (Enumeration e =  m_panel.process.variables.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); varList.addElement(s); }
    for  (Enumeration e =  m_panel.process.preconditions.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); condList.addElement(s); }
    for  (Enumeration e =  m_panel.process.effects.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); effList.addElement(s); }
    for  (Enumeration e =  m_panel.process.resources.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); resList.addElement(s); }
  }
}
