/*
 * @(#)CpeMainPanel.java	1.0 98/1/5
 */

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import java.beans.*;

import java.awt.Component;
import java.util.*;
import java.awt.BorderLayout;
import CpeChildPane;
import CpeRationPane;
import CpeActionItem;

/*
 * CpeMainPanel is the parent panel of the CpeChildPane windows. It
 * acts as the container for the internal windows.
 *
 * 1.0 98/1/5
 * @author Steve Polyak
 */
public class CpeMainPanel extends JPanel  {
  // Maker values
  JLayeredPane lc;
  int makeCount = 0;
  int processCount = 0;
  private String key = "";
  Vector processPanels = null;
  
  public CpeMainPanel(String key, CpeActionItem item)    {

    processPanels = new Vector();
    setKey(key);
    setLayout(new BorderLayout());
    lc = new JDesktopPane();
    lc.setOpaque(true);
    JInternalFrame maker = createNewFrame("", item);
    
    add("Center", lc);
  }
  
  public void setKey(String key) {
    this.key = key;
  }
  
  public String getKey() {
    return this.key;
  }
  
  public String createExpansion(String parentProcessKey) {
    //JInternalFrame maker = createNewFrame(parentProcessKey);
    //return maker.getTitle();
    return "";
  }
  
  /**
   * Used for moving down the abstraction hierarchy
   */
  public void showExpansion(CpeNode node, CpeProcessPanel panel) {
    JInternalFrame w = null;
    CpeProcessPanel tempPanel = null;
    String exp = node.expansion;
 
    tempPanel = locatePanel(exp);
 
    if (tempPanel != null) {
      w = tempPanel.frame;

      if (w.isIcon()) {
	try {
	  w.setIcon(false);
	} catch (PropertyVetoException exc) {};
      } 
      w.setBounds(panel.frame.getX(), panel.frame.getY(), w.getBounds().width,
		  w.getBounds().height);
      lc.moveToFront(w);
      Cpe.sharedInstance().updateRoot();
    }
  }

  /**
   * Used for moving up the abstraction hierarchy
   */
  public void showExpansion(String exp, CpeProcessPanel panel) {
    JInternalFrame w = null;
    CpeProcessPanel tempPanel = null;
 
    tempPanel = locatePanel(exp);
 
    if (tempPanel != null) {
      w = tempPanel.frame;

      if (w.isIcon()) {
	try {
	  w.setIcon(false);
	} catch (PropertyVetoException exc) {};
      } 
      w.setBounds(panel.frame.getX(), panel.frame.getY(), w.getBounds().width,
		  w.getBounds().height);
      lc.moveToFront(w);
      Cpe.sharedInstance().updateRoot();
    }
  }

  public CpeProcessPanel locatePanel(String key) {
    CpeProcessPanel returnPanel = null;
    CpeProcessPanel tempPanel = null;

    for  (Enumeration e =  processPanels.elements() ; 
	  e.hasMoreElements()  ;)  {	
      tempPanel = (CpeProcessPanel) e.nextElement();
      if (tempPanel.process.key.equals(key)) {
	returnPanel = tempPanel;
	break;
      }
    }
    return returnPanel;
  }

  protected JInternalFrame createNewFrame(String parentProcessKey, 
					  CpeActionItem item) {
    JInternalFrame w;
    int layer;
    w = new JInternalFrame();
    w.setClosable(false);
    w.setMaximizable(true);
    w.setIconifiable(true);
    w.setTitle(getKey() + "_" + ++processCount);
    w.setResizable(true);
    
    w.setBounds(20*makeCount, 20*makeCount, 300, 200);
    if(makeCount > 10)
      makeCount = 0;
    
    CpeChildPane child = null;
    //create as root if 1st process
    if (processCount == 1) {
      child = new CpeChildPane(this, 0, true);
    }else {
      child = new CpeChildPane(this, 0, false);
    }

    w.setContentPane(child);
    child.scroll.panel.process.setKey(w.getTitle());
    child.scroll.panel.process.expands = parentProcessKey;
    child.scroll.panel.frame = w;
    child.scroll.panel.process.actionItem = item;
    item.label = child.scroll.panel.process.label;
    item.process = child.scroll.panel.process;

    processPanels.addElement(child.scroll.panel);
    lc.add(w, new Integer(0));  
    try { w.setSelected(true); } catch (java.beans.PropertyVetoException e2) {}
    
    return w;
  }

  protected JInternalFrame createNewRationaleFrame(String parentProcessKey) {
    JInternalFrame w;
    int layer;
    w = new JInternalFrame();
    w.setClosable(false);
    w.setMaximizable(true);
    w.setIconifiable(true);
    w.setTitle("Rationale");
    w.setResizable(true);
    
    w.setBounds(20*makeCount, 20*makeCount, 300, 200);
    if(makeCount > 10)
      makeCount = 0;
    
    CpeRationPane child = null;
    //create as root if 1st process
    if (processCount == 1) {
      child = new CpeRationPane(this, 0, true);
    }else {
      child = new CpeRationPane(this, 0, false);
    }

    w.setContentPane(child);
    child.scroll.panel.process.setKey(w.getTitle());
    //child.scroll.panel.process.expands = parentProcessKey;
    child.scroll.panel.frame = w;

    //note I might want to have a separate list for rationale panels
    processPanels.addElement(child.scroll.panel);
    lc.add(w, new Integer(0));  
    try { w.setSelected(true); } catch (java.beans.PropertyVetoException e2) {}
    
    return w;
  }


  public void renameProcess(CpeProcessPanel panel, String original, 
			    String newlabel, boolean top) {

    panel.frame.setTitle(newlabel);
    if (top)
      Cpe.sharedInstance().renameTab(original, newlabel);
    Cpe.sharedInstance().updateRoot();
  }

  public void renameProcess(CpeRationPanel panel, String original, 
			    String newlabel, boolean top) {

    panel.frame.setTitle(newlabel);
    if (top)
      Cpe.sharedInstance().renameTab(original, newlabel);
    Cpe.sharedInstance().updateRoot();
  }

  public String createRationale(String parentProcessKey, String nodeKey) {
    JInternalFrame maker = 
      createNewRationaleFrame("ration"+parentProcessKey+nodeKey);
    return maker.getTitle();
  }

  public String createRationale(String parentProcessKey) {
    JInternalFrame maker = createNewRationaleFrame("ration"+parentProcessKey);
    return maker.getTitle();
  }


}
