import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import CpeDomainPane;
import CpeTreeItem;

public class CpeLevelsRoot extends CpeTreeItem
{

  CpeLevelsRoot(String label) {
    super(label);
  }

  public JPopupMenu createPopup(CpeDomainPane pane) {
    int ibegin, iend;
    String[] labels = new String[] { 
      "Add Level"};
      
    String[] commands = new String[] {
      "addlevel"};
      
    JPopupMenu popup = new JPopupMenu();
    ibegin = 0;
    iend = 0;
      
    for(int i=ibegin; i <= iend; i++) {
      if (labels[i].equals("-")) {
	popup.addSeparator();
      }
      else {
	JMenuItem mi = new JMenuItem(labels[i]);
	mi.setActionCommand(commands[i]);
	mi.addActionListener(pane);
	popup.add(mi);
      }
    }
    return popup;
  }

  public void writeOut(FtpModule ftp, DefaultMutableTreeNode node) {

    String levelString = "";
    DefaultMutableTreeNode childNode;
    CpeLevelsItem item;

    //first determine how many levels there are.
    int levelCount = node.getChildCount();

    if (levelCount > 0) {
	
      int i = 0; //level counter
      for  (Enumeration e = node.children(); e.hasMoreElements();i++){
	childNode = (DefaultMutableTreeNode) e.nextElement();
	item = (CpeLevelsItem) childNode.getUserObject();
	item.writeOut(ftp,childNode,i);
	if (i==0)
	  levelString = item.key;
	else
	  levelString = levelString + "," + item.key;
      }
      ftp.writeRemoteFile("SORT cpo-domain-level={" + levelString + "}");
    }
  }

}

