import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import CpeDomainPane;
import CpeTreeItem;

public class CpeInstanceItem extends CpeTreeItem
{

  boolean isResource = false;
  String resourceType = "";
  String units = "";
  String unitType = "";
  public DefaultMutableTreeNode node = null;

  CpeInstanceItem(String label) {
    super(label);
  }

  public void editProperties() {

    Object[] message = new Object[9];

    message[0] = "Instance label:";
    message[1] = new JTextField(label);
    message[2] = new JCheckBox("Resource", isResource);
    message[3] = "Resource Type:";
    message[4] = new JTextField(resourceType);
    message[5] = "Units:";
    message[6] = new JTextField(units);
    message[7] = "Unit Type:";
    message[8] = new JTextField(unitType);

    ((JTextField) message[1]).setFont(Cpe.sharedInstance().defaultFont);
    ((JTextField) message[4]).setFont(Cpe.sharedInstance().defaultFont);
    ((JTextField) message[6]).setFont(Cpe.sharedInstance().defaultFont);
    ((JTextField) message[8]).setFont(Cpe.sharedInstance().defaultFont);

    String[] options = {"OK"};
      
    JOptionPane.showOptionDialog(Cpe.sharedInstance().getFrame(), 
				 message, 
				 "Property Sheet...", 
				 JOptionPane.DEFAULT_OPTION, 
				 JOptionPane.QUESTION_MESSAGE,
				 null, options, options[0]);
    label = ((JTextField) message[1]).getText();
    isResource = ((JCheckBox) message[2]).isSelected();
    resourceType = ((JTextField) message[4]).getText();
    units = ((JTextField) message[6]).getText();
    unitType = ((JTextField) message[8]).getText();
  }

  public JPopupMenu createPopup(CpeDomainPane pane) {
    String[] labels = new String[] { 
      "Delete","-", "Properties"};
      
    String[] commands = new String[] {
      "delete", "-", "propinst"};
      
    JPopupMenu popup = new JPopupMenu();
      
    for(int i=0; i <= 2; i++) {
      if (labels[i].equals("-")) {
	popup.addSeparator();
      }
      else {
	JMenuItem mi = new JMenuItem(labels[i]);
	mi.setActionCommand(commands[i]);
	mi.addActionListener(pane);
	popup.add(mi);
      }
    }
    return popup;
  }

  public void writeOut(FtpModule ftp, DefaultMutableTreeNode node) {

    ftp.writeFunction("object.is-resource",key,
		      ((isResource) ? "true" : "false"));
    if (("".equals(resourceType)) == false)
      ftp.writeFunctionStr("object.resource-type",key,resourceType);
    if (("".equals(units)) == false) {
      ftp.cpo_unit.addElement(key+"u"); //SORT ref
      ftp.writeFunctionStr("unit.label",key+"u",units);
      ftp.write2Relation("object.unit",key,key+"u");
    }
    if (("".equals(unitType)) == false) 
      ftp.writeFunctionStr("unit.type",key+"u",unitType);
  }
}
