/*
 * @(#)CpeEdge.java	1.0 98/1/5
 * 
 */

import java.util.*;
import java.awt.*;
import CpeNode;

/**
 * CpeEdge is the base class representing an edge/arc in the process network.
 * Specialized edgea will inherit from this class.
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak 
 */
class CpeEdge {
  CpeNode m_from;
  boolean fromPosition; //true=begin, false=end
  CpeNode m_to;
  boolean toPosition; //true=begin, false=end
  final Color m_edgeColor = Color.black;
  boolean m_selected = false;
  final Color m_selectedColor = Color.pink;
  
  CpeEdge(CpeNode from, boolean fromPos, CpeNode to, boolean toPos){
    m_from = from;
    fromPosition = fromPos;
    m_to = to;
    toPosition = toPos;
  }
  
  //returns a rough area estimate used in checking for edge selection
  public Rectangle getRect(){
    if (m_from == null || m_to == null)
      return new Rectangle(0,0,0,0);

    int x,y,width,height, fromX, toX;

    fromX = this.fromX();
    toX = this.toX();

    if (fromX < toX) {
      x = fromX;
      width = toX - fromX;
    }
    else {
      x = toX;
      width = fromX - toX;
    }
    if (m_from.m_y < m_to.m_y) {
      y = m_from.m_y;
      height = m_to.m_y - m_from.m_y;
    }
    else {
      y = m_to.m_y;
      height = m_from.m_y - m_to.m_y;
    }
    
    if (width == 0)
      width = 1;
    if (height == 0)
      height = 1;
    
    return new Rectangle(x,y,width,height);
  }
  
  public void draw(Graphics g, FontMetrics fm) {

    if (m_from == null || m_to == null)
      return;

    int y1 = m_from.m_y;
    int y2 = m_to.m_y;
    int x1, x2;

    if (m_selected)
      g.setColor(m_selectedColor);
    else
      g.setColor(m_edgeColor);
    
    int wFrom = m_from.calcWidth(fm);
    int wTo = m_to.calcWidth(fm);

    if (fromPosition) {
      //drawing from the begin of the "from node"
      x1 = (m_from.m_x - wFrom/2);
    }
    else {
      //drawing from the end of the "from node"
      x1 = (m_from.m_x + wFrom/2);
    }

    if (toPosition) {
      //drawing to the begin of the "to node"
      x2 = (m_to.m_x - wTo/2);
    }
    else {
      //drawing to the end of the "to node"
      x2 = (m_to.m_x + wTo/2);
    }

    g.drawLine(x1, y1, x2, y2);
  }
  
  public void drawArrow(Graphics g, FontMetrics fm) {

    if (m_from == null || m_to == null)
      return;

    int y1 = m_from.m_y;
    int y2 = m_to.m_y;
    int x1, x2;

    if (m_selected)
      g.setColor(m_selectedColor);
    else
      g.setColor(m_edgeColor);
    
    int wTo = m_to.calcWidth(fm);
    int wFrom = m_from.calcWidth(fm);

    if (fromPosition) {
      //drawing from the begin of the "from node"
      x1 = (m_from.m_x - wFrom/2);
    }
    else {
      //drawing from the end of the "from node"
      x1 = (m_from.m_x + wFrom/2);
    }

    if (toPosition) {
      //drawing to the begin of the "to node"
      x2 = (m_to.m_x - wTo/2);
    }
    else {
      //drawing to the end of the "to node"
      x2 = (m_to.m_x + wTo/2);
    }

    placeArrow(g, x1, y1, x2, y2, 4);
  }
  
  public void placeArrow(Graphics g, int ax,int ay,int bx,int by, int r) {
    
    int dx = bx-ax;
    int dy = by-ay;
    double length = Math.sqrt(dx*dx+dy*dy);
    double sin = dy/length;
    double cos = dx/length;
    double px = length-r;
    double py = 0;
    double lx = px-2*r;
    double ly = r;
    double rx = lx;
    double ry = -ly;
    double mx = px-(3*r/2);
    double my = 0;
    double tx;
    double ty;
    tx = px*cos-py*sin;
    ty = px*sin+py*cos;
    px = tx; py = ty;
    tx = lx*cos-ly*sin;
    ty = lx*sin+ly*cos;
    lx = tx; ly = ty;
    tx = rx*cos-ry*sin;
    ty = rx*sin+ry*cos;
    rx = tx; ry = ty;
    tx = mx*cos-my*sin;
    ty = mx*sin+my*cos;
    mx = tx; my = ty;
    px+=ax; py+=ay;
    mx+=ax; my+=ay;
    lx+=ax; ly+=ay;
    rx+=ax; ry+=ay;
    int[] xvals = new int[4];
    int[] yvals = new int[4];
    xvals[0]=(int)px;
    xvals[1]=(int)lx;
    xvals[2]=(int)mx;
    xvals[3]=(int)rx;
    yvals[0]=(int)py;
    yvals[1]=(int)ly;
    yvals[2]=(int)my;
    yvals[3]=(int)ry;
    g.fillPolygon(xvals,yvals,4);
  }

  public int fromX() {
    if (fromPosition) {
      //drawing from the begin of the "from node"
      return (m_from.m_x - ((m_from.m_rect.width-10)/2));
    }
    else {
      //drawing from the end of the "from node"
      return (m_from.m_x + ((m_from.m_rect.width-10)/2));
    }
  }

  public int fromY() {
    return m_from.m_y;
  }

  public int toX() {
    if (toPosition) {
      //drawing from the begin of the "to node"
      return (m_to.m_x - ((m_to.m_rect.width-10)/2));
    }
    else {
      //drawing from the end of the "to node"
      return (m_to.m_x + ((m_to.m_rect.width-10)/2));
    }
  }

  public int toY() {
    return m_to.m_y;
  }

}
