import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import CpeDomainPane;
import CpeTreeItem;

public class CpeDomainRoot extends CpeTreeItem
{
  CpeDomainRoot(String label) {
    super(label);
  }
    
  public JPopupMenu createPopup(CpeDomainPane pane) {
    int ibegin, iend;
    String[] labels = new String[] { 
      "Save Domain", "-", "Properties"};
      
    String[] commands = new String[] {
      "savedomain","-", "propdom"};
      
    JPopupMenu popup = new JPopupMenu();
    ibegin = 0;
    iend = 2;
      
    for(int i=ibegin; i <= iend; i++) {
      if (labels[i].equals("-")) {
	popup.addSeparator();
      }
      else {
	JMenuItem mi = new JMenuItem(labels[i]);
	mi.setActionCommand(commands[i]);
	mi.addActionListener(pane);
	popup.add(mi);
      }
    }
    return popup;
  }
    
  public void writeOut(FtpModule ftp, DefaultMutableTreeNode node) {
    ftp.writeRemoteFile("%define-domain(" + label.replace(' ','_') + ")");
  }

}

