/*
 * @(#)CpeDomainPane.java	1.0 98/1/5
 */

import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import Cpe;
import CpeTreeRenderer;
import CpeLevelsItem;

/**
 * The domain pane is the primary browsing element for domains.
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak
 */
public class CpeDomainPane extends JPanel implements ActionListener
{
  Cpe cpe;
  JPopupMenu popup = null;
  JTree tree = null;
  protected DefaultTreeModel        treeModel;
  JScrollPane scrollPane  = null;
  DefaultMutableTreeNode cutCopyNode = null;

  DefaultMutableTreeNode top = new DefaultMutableTreeNode
  (new CpeDomainRoot("Domain: New Domain"));
  DefaultMutableTreeNode levels = null;
  DefaultMutableTreeNode types = null;
  DefaultMutableTreeNode always = null;

  public CpeDomainPane(Cpe cpe) {
    this.cpe = cpe;
    setLayout(new GridLayout(1,1));

    DefaultMutableTreeNode root = newtree();

    treeModel = new CpeTreeModel(root);
    tree = new JTree(treeModel);
    
    //tree.setCellRenderer(new CpeTreeRenderer());
    tree.setShowsRootHandles(true);
    tree.setRootVisible(true);
    //tree.setEditable(true);

    MouseListener ml = new MouseAdapter() {
      public void mouseClicked(MouseEvent e) {
	int selRow = tree.getRowForLocation(e.getX(), e.getY());
	TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
	if(selRow != -1) {

	  if(e.getClickCount() == 1) {
	    //singleClick(selRow, selPath);
	    //get sel node
	    DefaultMutableTreeNode node =
	      (DefaultMutableTreeNode)getSelectedNode();
	    if (node != null) {
	      //get obj
	      Object obj = node.getUserObject();
	      if ("CpeActionItem".equals(obj.getClass().getName())) {
		if (((CpeActionItem)obj).process != null) {
		  editProc((CpeActionItem) obj);
		}
	      }
	    }
	  }
	  else if(e.getClickCount() == 2) {
	    //doubleClick(selRow, selPath);
	    //System.out.println("Double click" + selRow + selPath);
            //double clicks only count on tree nodes attached to actions
            if ("CpeActionItem".equals
		(((DefaultMutableTreeNode)getSelectedNode()).getUserObject()
		 .getClass().getName()))
	      editProc((CpeActionItem)
		       ((DefaultMutableTreeNode)getSelectedNode())
		       .getUserObject());
	  }
	}
	else {
          tree.setSelectionRow(-1);
	}

	if (e.isMetaDown() && (selRow != -1)) {
	  popup = createPopup(getSelectedNode());
	  Cpe.sharedInstance().domainPane.add(popup);

	  //adjust for scroll.
	  int xpos = e.getX() - scrollPane.getHorizontalScrollBar().getValue();
	  int ypos = e.getY() - scrollPane.getVerticalScrollBar().getValue();

	  popup.show(Cpe.sharedInstance().domainPane, xpos,ypos);
	}
      }
    };
    tree.addMouseListener(ml);

    scrollPane = new JScrollPane(tree);
    add(scrollPane, BorderLayout.CENTER);
  }

  protected DefaultMutableTreeNode newtree() {
    
    levels = new DefaultMutableTreeNode(new CpeLevelsRoot("Levels"));
    types = new DefaultMutableTreeNode(new CpeTypesRoot("Types"));
    always = new DefaultMutableTreeNode(new CpeAlwaysRoot("Always"));
    
    top.add(levels);
    top.add(types);
    top.add(always);
    return top;
  }
  private JPopupMenu createPopup(DefaultMutableTreeNode node) {

    return ((CpeTreeItem) node.getUserObject()).createPopup(this);
  }

  /**
   * Returns the TreeNode instance that is selected in the tree.
   * If nothing is selected, null is returned.
   */
  protected DefaultMutableTreeNode getSelectedNode() {
    TreePath   selPath = tree.getSelectionPath();
    
    if(selPath != null)
      return (DefaultMutableTreeNode)selPath.getLastPathComponent();
    return null;
  }

  public void actionPerformed(ActionEvent event){
    String command = event.getActionCommand();
    
    if (command.equals("savedomain")){ Cpe.sharedInstance().saveDomainAs(); }
    else if (command.equals("addlevel")){ addLevel(); }
    else if (command.equals("addlevabove")){ addLevelAbove(); }
    else if (command.equals("addlevbelow")){ addLevelBelow(); }
    else if (command.equals("addalwaysexp")){ addAlwaysExpression(); }
    else if (command.equals("addlevbelow")){ addLevelBelow(); }
    else if (command.equals("addact")){ addAct(); }
    else if (command.equals("addtype")){ addType(); }
    else if (command.equals("addsub")){ addSubType(); }
    else if (command.equals("addinst")){ addInstance(); }
    else if (command.equals("delete")){ delItem(); }
    else if (command.equals("editproc"))
      {editProc((CpeActionItem)
		((DefaultMutableTreeNode)getSelectedNode())
		.getUserObject()); }
    else if (command.equals("delproc"))
      {delProc((CpeActionItem)
	       ((DefaultMutableTreeNode)getSelectedNode())
	       .getUserObject()); }
    else if (command.equals("prop")){ editProperties(); }
    else if (command.equals("propinst"))
      { ((CpeInstanceItem)
	 (((DefaultMutableTreeNode)getSelectedNode())
	  .getUserObject())).editProperties(); }
    else if (command.equals("propdom")){ editDomainProperties(); }
    else if (command.equals("cutproc")){ cutProc(); }
    else if (command.equals("pasteproc")){ pasteProc(); }
  }
  
  private void addLevel() {
    //this is to be added just below the level root.

    DefaultMutableTreeNode newLevelNode  = new 
      DefaultMutableTreeNode(new CpeLevelsItem("New_Level"));
    treeModel.insertNodeInto(newLevelNode,
			     getSelectedNode(), 0);
    addLevelStructure(newLevelNode);			     
  }

  public DefaultMutableTreeNode addLevel(String label) {
    //called by importer
    DefaultMutableTreeNode newLevelNode  = new 
      DefaultMutableTreeNode(new CpeLevelsItem(label));
    treeModel.insertNodeInto(newLevelNode,
			     levels, 0);
    addLevelStructure(newLevelNode);
    return newLevelNode;
  }

  private void addLevelAbove() {
    //This is to be added just above the selected level

    //calc position in child array
    int pos = ((DefaultMutableTreeNode) getSelectedNode()).getParent
      ().getIndex(getSelectedNode());

    DefaultMutableTreeNode newLevelNode  = new 
      DefaultMutableTreeNode(new CpeLevelsItem("New_Level"));

    treeModel.insertNodeInto(newLevelNode,
			     (DefaultMutableTreeNode)
			     (getSelectedNode().getParent()), pos);
    addLevelStructure(newLevelNode);			     
  }

  private void addLevelBelow() {
    //This is to be added just below the selected level
    //calc position in child array
    int pos = ((DefaultMutableTreeNode) getSelectedNode()).getParent
      ().getIndex(getSelectedNode()) + 1;

    DefaultMutableTreeNode newLevelNode  = new 
      DefaultMutableTreeNode(new CpeLevelsItem("New_Level"));

    treeModel.insertNodeInto(newLevelNode,
			     (DefaultMutableTreeNode)
			     (getSelectedNode().getParent()), pos);

    addLevelStructure(newLevelNode);
  }
  
  private void addLevelStructure(DefaultMutableTreeNode newLevelNode) {
			     
    DefaultMutableTreeNode newResourcesNode  = new 
      DefaultMutableTreeNode(new CpeResourcesItem("Resources"));
    treeModel.insertNodeInto(newResourcesNode,
			     newLevelNode, 0);

    DefaultMutableTreeNode newEffectsNode  = new 
      DefaultMutableTreeNode(new CpeEffectsItem("Effects"));
    treeModel.insertNodeInto(newEffectsNode,
			     newLevelNode, 0);

    DefaultMutableTreeNode newEventsNode  = new 
      DefaultMutableTreeNode(new CpeEventsItem("Events"));
    treeModel.insertNodeInto(newEventsNode,
			     newLevelNode, 0);

    DefaultMutableTreeNode newActionsNode  = new 
      DefaultMutableTreeNode(new CpeActionsItem("Actions"));
    treeModel.insertNodeInto(newActionsNode,
			     newLevelNode, 0);
  }

  private void addAlwaysExpression() {
    //this is to be added just below the always root.

    DefaultMutableTreeNode newNode  = new 
      DefaultMutableTreeNode(new CpeAlwaysItem("New_Expression"));
    treeModel.insertNodeInto(newNode,
			     getSelectedNode(), 0);
  }

  public void addAlwaysExpression(String exp) {
    //this is to be added just below the always root.

    DefaultMutableTreeNode newNode  = new 
      DefaultMutableTreeNode(new CpeAlwaysItem(exp));
    treeModel.insertNodeInto(newNode,always, 0);
  }

  private void addAct() {
    //this is to be added just below an actions root.

    DefaultMutableTreeNode newNode  = new 
      DefaultMutableTreeNode(new CpeActionItem("New_Action"));
    treeModel.insertNodeInto(newNode,
			     getSelectedNode(), 0);
  }

  public CpeActionItem addAct(String label, DefaultMutableTreeNode node) {
    CpeActionItem actionItem = new CpeActionItem(label);
    DefaultMutableTreeNode newNode  = new DefaultMutableTreeNode(actionItem);
    treeModel.insertNodeInto(newNode, node, 0);

    //now, need to add the actual process
    Cpe.sharedInstance().newProcess(actionItem);
    actionItem.process.setLabel(label);

    return actionItem;
  }

  private void addType() {
    //this is to be added just below the type root.

    DefaultMutableTreeNode newNode  = new 
      DefaultMutableTreeNode(new CpeTypeItem("New_Type"));
    treeModel.insertNodeInto(newNode,
			     getSelectedNode(), 0);
  }

  public CpeTypeItem addType(String label) {
    //this is to be added just below the type root.
    CpeTypeItem item = new CpeTypeItem(label);

    DefaultMutableTreeNode newNode  = new DefaultMutableTreeNode(item);
    treeModel.insertNodeInto(newNode, types, 0);
    item.node = newNode;
    return item;
  }

  public CpeTypeItem addType(String label, DefaultMutableTreeNode node) {

    CpeTypeItem item = new CpeTypeItem(label);

    DefaultMutableTreeNode newNode  = new DefaultMutableTreeNode(item);
    treeModel.insertNodeInto(newNode, node, 0);
    item.node = newNode;
    return item;
  }

  private void addSubType() {
    //this is to be added just below another type.

    DefaultMutableTreeNode newNode  = new 
      DefaultMutableTreeNode(new CpeTypeItem("New_Type"));
    treeModel.insertNodeInto(newNode,
			     getSelectedNode(), 0);
  }

  private void addInstance() {

    DefaultMutableTreeNode newNode  = new 
      DefaultMutableTreeNode(new CpeInstanceItem("New_Object"));
    treeModel.insertNodeInto(newNode,
			     getSelectedNode(), 0);
  }

  public CpeInstanceItem addInstance(String label, 
				     DefaultMutableTreeNode node) {

    CpeInstanceItem item = new CpeInstanceItem(label);

    DefaultMutableTreeNode newNode  = new DefaultMutableTreeNode(item);
    treeModel.insertNodeInto(newNode, node, 0);
    item.node = newNode;
    return item;
  }

  private void delItem() {
    treeModel.removeNodeFromParent(getSelectedNode());
  }

  private void editProc(CpeActionItem item) {

    if (item.process == null) {
      Cpe.sharedInstance().newProcess(item);
      Cpe.sharedInstance().openProcess();
      Cpe.sharedInstance().updateRoot();
    }
    else {
      Cpe.sharedInstance().bringProcToFront(item.process);
    }

  }

  private void delProc(CpeActionItem item) {

    if (item.process == null) {
      treeModel.removeNodeFromParent(getSelectedNode());
    }
    else {
      Cpe.sharedInstance().closeProcess(item.process.key);
      treeModel.removeNodeFromParent(getSelectedNode());
    }
    Cpe.sharedInstance().updateRoot();

  }

  private void editProperties() {

    CpeTreeItem item = null;
    Object[] message = new Object[2];

    item = (CpeTreeItem) getSelectedNode().getUserObject();
    message[0] = "Node label:";
    message[1] = new JTextField(item.label);
    ((JTextField) message[1]).setFont(Cpe.sharedInstance().defaultFont);
    
    String[] options = {"OK"};

    JOptionPane.showOptionDialog(Cpe.sharedInstance().getFrame(), 
				 message, 
				 "Property Sheet...", 
				 JOptionPane.DEFAULT_OPTION, 
				 JOptionPane.QUESTION_MESSAGE,
				 null, options, options[0]);
    item.label = ((JTextField) message[1]).getText();
  }


  private void editDomainProperties() {

    CpeTreeItem item = null;
    Object[] message = new Object[2];

    item = (CpeTreeItem) getSelectedNode().getUserObject();
    message[0] = "Domain label:";
    message[1] = new JTextField(item.label);
    ((JTextField) message[1]).setFont(Cpe.sharedInstance().defaultFont);
    
    String[] options = {"OK"};

    JOptionPane.showOptionDialog(Cpe.sharedInstance().getFrame(), 
				 message, 
				 "Property Sheet...", 
				 JOptionPane.DEFAULT_OPTION, 
				 JOptionPane.QUESTION_MESSAGE,
				 null, options, options[0]);
    item.label = ((JTextField) message[1]).getText();
    Cpe.sharedInstance().fileName = item.label + ".cpd";
  }

  private void cutProc() {

    cutCopyNode = getSelectedNode();
    treeModel.removeNodeFromParent(getSelectedNode());
  }

  private void pasteProc() {
    if (cutCopyNode != null)
      treeModel.insertNodeInto(cutCopyNode,
			       getSelectedNode(), 0);
    cutCopyNode = null;
  }

  public Dimension getMinimumSize() {
    return new Dimension(20,20);
  }

}
