import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import CpeDomainPane;
import CpeTreeItem;

public class CpeActionsItem extends CpeTreeItem
{

  CpeActionsItem(String label) {
    super(label);
  }

  public JPopupMenu createPopup(CpeDomainPane pane) {
    int ibegin, iend;
    String[] labels = new String[] { 
      "Add Action","-","Paste"};
      
    String[] commands = new String[] {
      "addact","-","pasteproc"};
      
    JPopupMenu popup = new JPopupMenu();
    ibegin = 0;
    iend = 2;
      
    for(int i=ibegin; i <= iend; i++) {
      if (labels[i].equals("-")) {
	popup.addSeparator();
      }
      else {
	JMenuItem mi = new JMenuItem(labels[i]);
	mi.setActionCommand(commands[i]);
	mi.addActionListener(pane);
	popup.add(mi);
      }
    }
    return popup;
  }

  public void writeOut(FtpModule ftp, DefaultMutableTreeNode node,
		       String level) {

    DefaultMutableTreeNode childNode;
    CpeActionItem item;

    //first determine how many actions there are.
    int actionCount = node.getChildCount();
      
    if (actionCount > 0) {
	
      for  (Enumeration e = node.children(); e.hasMoreElements();){
	childNode = (DefaultMutableTreeNode) e.nextElement();
	item = (CpeActionItem) childNode.getUserObject();
	ftp.writeRemoteFile("domain-level.contains("+level+","+
			    item.key+")");
	item.writeOut(ftp,childNode);
      }
    }
  }
}

