/*
Common Process Framework - Simple control panel for the CPF tools.
Steve Polyak.
August 26, 1998
*/  

import java.awt.*;
import java.awt.event.*;
import java.lang.Runtime.*;
import com.sun.java.swing.*;

public class cpf extends JPanel {
  static JFrame frame;
  
  // load images
  ImageIcon cog = new ImageIcon
  ("images/cog.gif","black back");
  ImageIcon cogDown = new ImageIcon
  ("images/cogDown.gif","blue back");
  ImageIcon cogRoll = new ImageIcon
  ("images/cogRoll.gif","yellow back");
  ImageIcon quitDown = new ImageIcon
  ("images/quitDown.gif","yellow back");

  public cpf() {

    JButton button;

    // Create the buttons.
    button = createButton("CPM... ", 
			  "Launch the Common Process Methodology...",
			  cog, cogDown, cogRoll);
    button.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	try {
	  Runtime.getRuntime().exec("sh cpm");
	} catch (Exception exc) {
          System.out.println(exc.getMessage());  
	}
      }
    });
    add(button);

    button = createButton("CDE... ", "Launch the Common Domain Editor...", 
			  cog, cogDown, cogRoll);
    button.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	try {
	  Runtime.getRuntime().exec("sh cde");
	} catch (Exception exc) {
          System.out.println(exc.getMessage());  
	}
      }
    });
    add(button);

    button = createButton("O-Plan... ", "Launch O-Plan...", 
			  cog, cogDown, cogRoll);
    button.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	try {
	  Runtime.getRuntime().exec("sh oplan");
	} catch (Exception exc) {
          System.out.println(exc.getMessage());  
	}
      }
    });
    add(button);

    button = createButton("CPE... ", "Launch Common Process Editor...", 
			  cog, cogDown, cogRoll);
    button.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	try {
	  Runtime.getRuntime().exec("sh cpe");
	} catch (Exception exc) {
          System.out.println(exc.getMessage());  
	}
      }
    });
    add(button);

    button = createButton("CPA... ", "Launch Common Process Assistant...", 
			  cog, cogDown, cogRoll);
    button.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	JOptionPane.showMessageDialog(null, 
				      "Launch cpa from the command line.", 
				      "CPF Message", 
				      JOptionPane.INFORMATION_MESSAGE);
      }
    });
    add(button);

    button = createButton("Quit ", "Close CPF", 
			  cog, quitDown, cogRoll);
    button.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	try {
	  System.exit(0);
	} catch (Exception exc) {
          System.out.println(exc.getMessage());  
	}
      }
    });
    add(button);
    
  }
  
  private JButton createButton(String label, String tool, ImageIcon icon,
			       ImageIcon press, ImageIcon roll) {

    JButton button = new JButton(label, icon);
    button.setPressedIcon(press);
    button.setRolloverIcon(roll);
    button.setRolloverEnabled(true);
    button.setToolTipText(tool);
    return button;
  }

  public static void main(String s[]) {
    
    cpf panel = new cpf();
    
    frame = new JFrame("Common Process Framework");
    frame.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {System.exit(0);}
    });
    frame.getContentPane().add("Center", panel);
    frame.pack();
    frame.setVisible(true);
  }
}
