/*
 * Decompiled with CFR 0.152.
 */
package mousegui15;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import mouse.BeforeAfterCassette;
import mouse.Cassette;
import mouse.IntersectionSet;
import mousegui15.DatasetDetails;
import mousegui15.DisplayResults;
import mousegui15.Random;
import mousegui15.TextAreaRenderer;
import mousegui15.UserDialog;

public class MouseMainWindow
extends JFrame {
    String filename;
    protected String user;
    protected String pwd;
    HashMap<Integer, BeforeAfterCassette> selected_cassettes = new HashMap();
    static int count = 0;
    private JButton AddCassetteButton;
    private JButton CalcIntersectionsButton;
    private JButton EditButton;
    private JButton RandomSetButton;
    private JButton RemoveCassetteButton;
    private JMenuItem aboutMenuItem;
    private JTable dataset_table;
    private JScrollPane dataset_table_panel;
    private JPanel east;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu globalActionsMenu;
    private JMenuItem globalChangeBetweenMethod;
    private JMenuItem globalChangeWithinMethod;
    private JMenuItem globalRefresh;
    private JMenuItem globalSwap;
    private JMenu helpMenu;
    private JDialog jDialog1;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JMenuItem loadMenuItem;
    private JMenuBar menuBar;
    private JPanel pnlNorth;
    private JPanel pnlSouth;
    private JMenuItem resetMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem userItem;
    private JPanel west;

    public void saveUserData() {
        try {
            PrintWriter printi = new PrintWriter(new FileWriter(new File(".config")));
            printi.println(this.user);
            printi.println(this.pwd);
            printi.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean loadUserData() {
        try {
            BufferedReader buffy = new BufferedReader(new FileReader(".config"));
            this.user = buffy.readLine();
            this.pwd = buffy.readLine();
            if (this.user.split(" ").length != 1 || this.pwd.split(" ").length != 1) {
                this.user = null;
                this.pwd = null;
                throw new IOException("Illegal content in config file!");
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setUser(String uname, String upwd) {
        this.user = uname;
        this.pwd = upwd;
        this.saveUserData();
    }

    public void addCassette(int index, BeforeAfterCassette c) {
        this.selected_cassettes.put(index, c);
        this.refresh();
    }

    protected void refresh() {
        DefaultTableModel model = (DefaultTableModel)this.dataset_table.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
        Set<Integer> ss = this.selected_cassettes.keySet();
        for (Integer key : ss) {
            BeforeAfterCassette current = this.selected_cassettes.get(key);
            model.addRow(new Object[]{key, current.getLabel(), current.size(), current.getComment()});
        }
        this.globalActionsMenu.setEnabled(this.selected_cassettes.size() > 0);
        this.saveMenuItem.setEnabled(this.selected_cassettes.size() > 0);
        this.saveAsMenuItem.setEnabled(this.selected_cassettes.size() > 0);
    }

    public MouseMainWindow() {
        this.initComponents();
        try {
            this.loadUserData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dataset_table_panel.setViewportView(this.dataset_table);
        this.dataset_table.getColumn("No.").setPreferredWidth(40);
        this.dataset_table.getColumn("No.").setMinWidth(40);
        this.dataset_table.getColumn("No.").setMaxWidth(40);
        this.dataset_table.getColumn("Name").setPreferredWidth(350);
        this.dataset_table.getColumn("Size").setPreferredWidth(40);
        this.dataset_table.getColumn("Size").setMinWidth(40);
        this.dataset_table.getColumn("Size").setMaxWidth(40);
        this.dataset_table.getColumn("Comment").setPreferredWidth(450);
        this.dataset_table.getColumnModel().getColumn(1).setCellRenderer(new TextAreaRenderer());
        this.dataset_table.getColumnModel().getColumn(3).setCellRenderer(new TextAreaRenderer());
    }

    private void initComponents() {
        this.jDialog1 = new JDialog();
        this.pnlNorth = new JPanel();
        this.jLabel4 = new JLabel();
        this.pnlSouth = new JPanel();
        this.east = new JPanel();
        this.CalcIntersectionsButton = new JButton();
        this.west = new JPanel();
        this.AddCassetteButton = new JButton();
        this.RemoveCassetteButton = new JButton();
        this.EditButton = new JButton();
        this.RandomSetButton = new JButton();
        this.dataset_table_panel = new JScrollPane();
        this.dataset_table = new JTable();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.resetMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.loadMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.userItem = new JMenuItem();
        this.globalActionsMenu = new JMenu();
        this.globalChangeWithinMethod = new JMenuItem();
        this.globalChangeBetweenMethod = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.globalRefresh = new JMenuItem();
        this.globalSwap = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new BorderLayout(8, 8));
        this.setDefaultCloseOperation(3);
        this.setTitle("GXD-search");
        this.pnlNorth.setLayout(new FlowLayout(0));
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Selected Cassettes");
        this.pnlNorth.add(this.jLabel4);
        this.getContentPane().add((Component)this.pnlNorth, "North");
        this.pnlSouth.setLayout(new BorderLayout());
        this.east.setLayout(new FlowLayout(0));
        this.CalcIntersectionsButton.setFont(new Font("Tahoma", 1, 11));
        this.CalcIntersectionsButton.setText("Do Intersections");
        this.CalcIntersectionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.CalcIntersectionsButtonActionPerformed(evt);
            }
        });
        this.east.add(this.CalcIntersectionsButton);
        this.pnlSouth.add((Component)this.east, "East");
        this.west.setLayout(new FlowLayout(2));
        this.AddCassetteButton.setText("Add");
        this.AddCassetteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.AddCassetteButtonActionPerformed(evt);
            }
        });
        this.west.add(this.AddCassetteButton);
        this.RemoveCassetteButton.setText("Remove");
        this.RemoveCassetteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.RemoveCassetteButtonActionPerformed(evt);
            }
        });
        this.west.add(this.RemoveCassetteButton);
        this.EditButton.setText("Edit");
        this.EditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.EditButtonActionPerformed(evt);
            }
        });
        this.west.add(this.EditButton);
        this.RandomSetButton.setText("Random Set");
        this.RandomSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.RandomSetButtonActionPerformed(evt);
            }
        });
        this.west.add(this.RandomSetButton);
        this.pnlSouth.add((Component)this.west, "West");
        this.getContentPane().add((Component)this.pnlSouth, "South");
        this.dataset_table_panel.setAutoscrolls(true);
        this.dataset_table_panel.setPreferredSize(new Dimension(640, 480));
        this.dataset_table.setModel(new DefaultTableModel(new Object[0][], new String[]{"No.", "Name", "Size", "Comment"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, Integer.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.dataset_table.setAutoResizeMode(4);
        this.dataset_table.setSurrendersFocusOnKeystroke(true);
        this.dataset_table.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MouseMainWindow.this.dataset_tableFocusLost(evt);
            }
        });
        this.dataset_table_panel.setViewportView(this.dataset_table);
        this.getContentPane().add((Component)this.dataset_table_panel, "Center");
        this.fileMenu.setText("File");
        this.resetMenuItem.setText("New Project");
        this.resetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.resetMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.resetMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.loadMenuItem.setText("Load Project");
        this.loadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.loadMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadMenuItem);
        this.saveMenuItem.setText("Save Project");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText("Save as...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.userItem.setText("Change User Info");
        this.userItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.userItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.userItem);
        this.globalActionsMenu.setText("Global Actions");
        this.globalActionsMenu.setEnabled(false);
        this.globalChangeWithinMethod.setText("Change Within-Group Method");
        this.globalChangeWithinMethod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.globalChangeWithinMethodActionPerformed(evt);
            }
        });
        this.globalActionsMenu.add(this.globalChangeWithinMethod);
        this.globalChangeBetweenMethod.setText("Change Between-Group Method");
        this.globalChangeBetweenMethod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.globalChangeBetweenMethodActionPerformed(evt);
            }
        });
        this.globalActionsMenu.add(this.globalChangeBetweenMethod);
        this.globalActionsMenu.add(this.jSeparator3);
        this.globalRefresh.setText("Refresh all datasets...");
        this.globalRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.globalRefreshActionPerformed(evt);
            }
        });
        this.globalActionsMenu.add(this.globalRefresh);
        this.globalSwap.setText("Swap all Before/After cassettes");
        this.globalSwap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.globalSwapActionPerformed(evt);
            }
        });
        this.globalActionsMenu.add(this.globalSwap);
        this.editMenu.add(this.globalActionsMenu);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MouseMainWindow.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void userItemActionPerformed(ActionEvent evt) {
        new UserDialog(this, true).setVisible(true);
    }

    private void globalRefreshActionPerformed(ActionEvent evt) {
        if (DatasetDetails.children_map == null) {
            new DatasetDetails(this, null, -1).dispose();
        }
        for (BeforeAfterCassette current : this.selected_cassettes.values()) {
            Cassette c;
            int j;
            Vector<Integer> beforeKeys = current.beforeKeys;
            Vector<Integer> afterKeys = current.afterKeys;
            Vector<Cassette> before = current.before;
            Vector<Cassette> after = current.after;
            current.clear();
            for (j = 0; j < beforeKeys.size(); ++j) {
                c = DatasetDetails.getCassetteFromDB(beforeKeys.get(j).toString(), before.get((int)j).label, before.get((int)j).contents, this.user, this.pwd);
                c.stage = before.get((int)j).stage;
                current.addBefore(c, beforeKeys.get(j));
            }
            for (j = 0; j < afterKeys.size(); ++j) {
                c = DatasetDetails.getCassetteFromDB(afterKeys.get(j).toString(), after.get((int)j).label, after.get((int)j).contents, this.user, this.pwd);
                c.stage = after.get((int)j).stage;
                current.addAfter(c, afterKeys.get(j));
            }
            current.refresh();
        }
        this.refresh();
    }

    private void globalSwapActionPerformed(ActionEvent evt) {
        for (BeforeAfterCassette current : this.selected_cassettes.values()) {
            Vector<Integer> tmpKeys = current.beforeKeys;
            Vector<Cassette> tmp = current.before;
            current.beforeKeys = current.afterKeys;
            current.before = current.after;
            current.afterKeys = tmpKeys;
            current.after = tmp;
            current.refresh();
        }
        this.refresh();
    }

    private void globalChangeBetweenMethodActionPerformed(ActionEvent evt) {
        byte method;
        Object[] choices = new Object[]{"Minus", "Difference", "InverseMinus"};
        Object choice = JOptionPane.showInputDialog(this, "Please choose the Between-Group method:", "Global Change of Between-Group Method", -1, null, choices, "Minus");
        if (choice == null) {
            return;
        }
        if (choice.equals(choices[0])) {
            method = 2;
        } else if (choice.equals(choices[1])) {
            method = 3;
        } else if (choice.equals(choices[2])) {
            method = 4;
        } else {
            return;
        }
        for (BeforeAfterCassette current : this.selected_cassettes.values()) {
            current.setDifferenceMethod(method);
            current.refresh();
        }
        this.refresh();
    }

    private void globalChangeWithinMethodActionPerformed(ActionEvent evt) {
        byte method;
        Object[] choices = new Object[]{"Union", "Intersection"};
        Object choice = JOptionPane.showInputDialog(this, "Please choose the Within-Group method:", "Global Change of Within-Group Method", -1, null, choices, "Union");
        if (choice == null) {
            return;
        }
        if (choice.equals(choices[0])) {
            method = 0;
        } else if (choice.equals(choices[1])) {
            method = 1;
        } else {
            return;
        }
        for (BeforeAfterCassette current : this.selected_cassettes.values()) {
            current.setIntersectionMethod(method);
            current.refresh();
        }
        this.refresh();
    }

    private void RandomSetButtonActionPerformed(ActionEvent evt) {
        Random rr = new Random(this, count);
        rr.setVisible(true);
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        this.saveAs(null);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        this.saveAs(null);
    }

    private void saveAs(String fn) {
        if (fn == null) {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File("./projects/"));
            fc.setMultiSelectionEnabled(false);
            if (fc.showSaveDialog(this) == 0) {
                this.filename = fc.getSelectedFile().getAbsolutePath();
            } else {
                return;
            }
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.filename));
            Set<Integer> ss = this.selected_cassettes.keySet();
            for (Integer key : ss) {
                BeforeAfterCassette current = this.selected_cassettes.get(key);
                oos.writeObject(current);
            }
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("./projects/"));
        fc.setMultiSelectionEnabled(false);
        if (fc.showOpenDialog(this) != 0) {
            return;
        }
        this.filename = fc.getSelectedFile().getAbsolutePath();
        this.selected_cassettes = new HashMap();
        count = 0;
        try {
            Object o;
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.filename));
            while ((o = ois.readObject()) != null) {
                this.selected_cassettes.put(count++, (BeforeAfterCassette)o);
            }
            ois.close();
        }
        catch (EOFException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error loading file.", "Load Error", 0);
        }
        this.refresh();
    }

    private void resetMenuItemActionPerformed(ActionEvent evt) {
        this.selected_cassettes = new HashMap();
        count = 0;
        this.filename = null;
        this.refresh();
    }

    private void EditButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.dataset_table.getModel();
        int[] selections = this.dataset_table.getSelectedRows();
        Arrays.sort(selections);
        if (selections.length == 0) {
            JOptionPane.showMessageDialog(this, "No datasets have been selected.", "No Selection", 2);
        }
        if (selections.length > 1) {
            JOptionPane.showMessageDialog(this, "Only one selection allowed.", "Too Many Selections", 2);
            return;
        }
        for (int i = selections.length - 1; i >= 0; --i) {
            int index = (Integer)model.getValueAt(selections[i], 0);
            DatasetDetails dd = new DatasetDetails(this, this.selected_cassettes.get(index), index);
            dd.setLocation((i + 1) * 40, (i + 1) * 40);
            dd.setVisible(true);
        }
    }

    private void dataset_tableFocusLost(FocusEvent evt) {
    }

    private void CalcIntersectionsButtonActionPerformed(ActionEvent evt) {
        if (this.userSelected()) {
            if (this.dataset_table.getRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "You must add a few datasets before\nyou can calculate intersections.", "No Data Selected", 2);
            } else {
                BeforeAfterCassette[] datasets = this.selected_cassettes.values().toArray(new BeforeAfterCassette[this.selected_cassettes.size()]);
                IntersectionSet is = new IntersectionSet(datasets.length);
                is.calculateIntersections(datasets);
                new DisplayResults((Frame)this, true, is).setVisible(true);
            }
        } else {
            JOptionPane.showMessageDialog(this, "You must log in before you can add data!", "No Connection to DB", 2);
            new UserDialog(this, true).setVisible(true);
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "GXD-search v1.5.2\n\n(c) 2008, by Mei Sze Lam (lam.meisze@gmail.com)\nIn cooperation with Stuart Aitken and Jonathan Bard\n(to whom questions should be addressed: j.bard@ed.ac.uk).", "About...", 1);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void RemoveCassetteButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.dataset_table.getModel();
        int[] selections = this.dataset_table.getSelectedRows();
        Arrays.sort(selections);
        if (selections.length == 0) {
            JOptionPane.showMessageDialog(this, "No datasets have been selected for removal.", "No Selection", 2);
        }
        for (int i = selections.length - 1; i >= 0; --i) {
            int index = (Integer)model.getValueAt(selections[i], 0);
            this.selected_cassettes.remove(index);
        }
        this.refresh();
    }

    private void AddCassetteButtonActionPerformed(ActionEvent evt) {
        if (this.userSelected()) {
            DatasetDetails dd = new DatasetDetails(this, null, count);
            dd.setLocation(40, 40);
            dd.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "You must log in before you can add data!", "No Connection to DB", 2);
            new UserDialog(this, true).setVisible(true);
        }
    }

    private boolean userSelected() {
        return this.user != null & this.pwd != null;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MouseMainWindow().setVisible(true);
            }
        });
    }
}

