/*
 * Decompiled with CFR 0.152.
 */
package mousegui15;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import javax.swing.JPanel;

public class IntersectedSetGraphics
extends JPanel {
    static final float[] dash1 = new float[]{10.0f};
    static final BasicStroke dashed = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);
    private String method;
    private boolean process;

    public IntersectedSetGraphics(String meth, boolean process) {
        this.method = meth.trim().toLowerCase();
        this.process = process;
        this.setPreferredSize(new Dimension(150, 80));
        this.setVisible(true);
    }

    public void paintComponent(Graphics g) {
        this.clear(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.BLACK);
        g2d.setStroke(dashed);
        g2d.draw(new Ellipse2D.Double(0.0, 0.0, 80.0, 80.0));
        Area a1 = new Area(new Ellipse2D.Double(0.0, 0.0, 80.0, 80.0));
        g2d.draw(new Ellipse2D.Double(60.0, 0.0, 80.0, 80.0));
        Area a2 = new Area(new Ellipse2D.Double(60.0, 0.0, 80.0, 80.0));
        Area result = a1;
        if (this.method.equals("difference")) {
            result.exclusiveOr(a2);
        } else if (this.method.equals("union")) {
            result.add(a2);
        } else if (this.method.equals("minus")) {
            result.subtract(a2);
        } else if (this.method.equals("inverse minus")) {
            result = a2;
            result.subtract(a1);
        } else if (this.method.equals("intersection")) {
            result.intersect(a2);
        } else {
            throw new IllegalArgumentException("Unknown method: " + this.method);
        }
        if (this.process) {
            g2d.drawString("Before", 10, 45);
            g2d.drawString("After", 95, 45);
        } else {
            g2d.drawString("Tissue A", 5, 45);
            g2d.drawString("Tissue B", 85, 45);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
        g2d.setColor(Color.blue);
        g2d.fill(result);
    }

    protected void clear(Graphics g) {
        super.paintComponent(g);
    }
}

