/*
 * Decompiled with CFR 0.152.
 */
package mousegui15;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import mouse.Gene;
import mouse.IntersectionCassette;
import mouse.IntersectionSet;
import mousegui15.ContrastReport;
import mousegui15.TextAreaRenderer;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class DisplayResults
extends JDialog {
    HashMap<Integer, IntersectionCassette> intersectedcassettes;
    Frame parent;
    private JButton closeButton;
    private JButton cmdReport;
    private JButton deleteRowButton;
    private JScrollPane jScrollPane1;
    private JTable results_table;
    private JButton saveToFileButton;

    private void fillTable(IntersectionSet is) {
        this.intersectedcassettes = new HashMap();
        IntersectionCassette[][] intersections = is.intersections;
        int count = 0;
        this.results_table.getColumnModel().getColumn(1).setCellRenderer(new TextAreaRenderer());
        this.results_table.getColumnModel().getColumn(4).setCellRenderer(new TextAreaRenderer());
        for (int i = 0; i < intersections.length; ++i) {
            for (int j = 0; j < intersections[i].length; ++j) {
                DefaultTableModel model = (DefaultTableModel)this.results_table.getModel();
                IntersectionCassette current = intersections[i][j];
                model.addRow(new Object[]{count, current.getLabel(), current.intersected_cassettes.size(), current.size(), current.getGenes()});
                this.intersectedcassettes.put(count, current);
                ++count;
            }
        }
    }

    public DisplayResults(Frame parent, boolean modal, IntersectionSet results) {
        super(parent, modal);
        this.initComponents();
        this.parent = parent;
        this.fillTable(results);
        this.results_table.getColumn("No.").setPreferredWidth(10);
        this.results_table.getColumn("Permutation").setPreferredWidth(220);
        this.results_table.getColumn("#Sets").setPreferredWidth(10);
        this.results_table.getColumn("Size").setPreferredWidth(10);
        this.results_table.getColumn("Genes").setPreferredWidth(400);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.results_table = new JTable();
        this.saveToFileButton = new JButton();
        this.deleteRowButton = new JButton();
        this.cmdReport = new JButton();
        this.closeButton = new JButton();
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("Intersection Results");
        this.setResizable(false);
        this.jScrollPane1.setAutoscrolls(true);
        this.jScrollPane1.setPreferredSize(new Dimension(640, 480));
        this.results_table.setModel(new DefaultTableModel(new Object[0][], new String[]{"No.", "Permutation", "#Sets", "Size", "Genes"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Object.class, Integer.class, Integer.class, Object.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.results_table.setAutoResizeMode(4);
        this.jScrollPane1.setViewportView(this.results_table);
        this.getContentPane().add((Component)this.jScrollPane1, new AbsoluteConstraints(6, 5, -1, -1));
        this.saveToFileButton.setLabel("Save to Text File");
        this.saveToFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DisplayResults.this.saveToFileButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.saveToFileButton, new AbsoluteConstraints(240, 490, -1, -1));
        this.deleteRowButton.setLabel("Delete Row");
        this.deleteRowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DisplayResults.this.deleteRowButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.deleteRowButton, new AbsoluteConstraints(380, 490, -1, -1));
        this.cmdReport.setText("Report");
        this.cmdReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DisplayResults.this.cmdReportActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.cmdReport, new AbsoluteConstraints(490, 490, -1, -1));
        this.closeButton.setLabel("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DisplayResults.this.closeButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.closeButton, new AbsoluteConstraints(570, 490, -1, -1));
        this.pack();
    }

    private void cmdReportActionPerformed(ActionEvent evt) {
        int[] indices = this.results_table.getSelectedRows();
        if (indices.length == 0) {
            return;
        }
        IntersectionCassette[] selectedintersections = new IntersectionCassette[indices.length];
        DefaultTableModel model = (DefaultTableModel)this.results_table.getModel();
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            int intersection_index = (Integer)model.getValueAt(index, 0);
            selectedintersections[i] = this.intersectedcassettes.get(intersection_index);
            System.out.println("i = " + i + ", index = " + index + ", intersection_index = " + intersection_index + ", dataset = " + selectedintersections[i].getLabel());
        }
        ContrastReport cr = new ContrastReport(this.parent, false, selectedintersections);
        cr.setLocation(10, 10);
        cr.setVisible(true);
        this.dispose();
    }

    private void saveToFileButtonActionPerformed(ActionEvent evt) {
        int[] printlist = this.results_table.getSelectedRows();
        if (printlist.length != 1) {
            JOptionPane.showMessageDialog(this, "You may only save one permutation at a time.", "Invalid Selection", 2);
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("./projects/textfiles/"));
        fc.setMultiSelectionEnabled(false);
        if (fc.showSaveDialog(this) != 0) {
            return;
        }
        String filename = fc.getSelectedFile().getAbsolutePath();
        IntersectionCassette ic = this.intersectedcassettes.get((Integer)this.results_table.getModel().getValueAt(printlist[0], 0));
        File filey = new File(filename);
        try {
            PrintWriter printey = new PrintWriter(new FileWriter(filey));
            printey.println("Intersection Results for " + ic.getLabel());
            printey.println();
            printey.println("Original Structures:");
            printey.println();
            for (int i = 0; i < ic.intersected_cassettes.size(); ++i) {
                printey.println("Name: " + ic.intersected_cassettes.get(i).getLabel());
                printey.println("Before: " + ic.intersected_cassettes.get(i).toStringBefore());
                printey.println("After: " + ic.intersected_cassettes.get(i).toStringAfter());
                printey.println();
            }
            printey.println("-----------------------------------");
            for (int m = 0; m < ic.genes.size(); ++m) {
                printey.println(((Gene)ic.genes.get(m)).toString());
            }
            printey.flush();
            printey.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteRowButtonActionPerformed(ActionEvent evt) {
        int[] rubbish = this.results_table.getSelectedRows();
        Arrays.sort(rubbish);
        DefaultTableModel model = (DefaultTableModel)this.results_table.getModel();
        for (int i = rubbish.length - 1; i >= 0; --i) {
            model.removeRow(rubbish[i]);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

