/*
 * Decompiled with CFR 0.152.
 */
package mousegui15;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import mousegui15.DatasetDetails;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class DatasetDetailsOptions
extends JDialog {
    DatasetDetails parent;
    private ButtonGroup betweenButtonGroup;
    private JRadioButton differenceButton;
    private JRadioButton intersectButton;
    private JRadioButton inverseButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JRadioButton minusButton;
    private JButton okButton;
    private JRadioButton unionButton;
    private ButtonGroup withinButtonGroup;

    public DatasetDetailsOptions(DatasetDetails parent, boolean modal) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.initComponents();
        this.withinButtonGroup.add(this.unionButton);
        this.withinButtonGroup.add(this.intersectButton);
        this.betweenButtonGroup.add(this.minusButton);
        this.betweenButtonGroup.add(this.differenceButton);
        this.betweenButtonGroup.add(this.inverseButton);
        this.initSelections();
    }

    private void initSelections() {
        this.unionButton.setSelected(this.parent.dataset.getIntersectionMethod() == 0);
        this.intersectButton.setSelected(this.parent.dataset.getIntersectionMethod() == 1);
        this.minusButton.setSelected(this.parent.dataset.getDifferenceMethod() == 2);
        this.differenceButton.setSelected(this.parent.dataset.getDifferenceMethod() == 3);
        this.inverseButton.setSelected(this.parent.dataset.getDifferenceMethod() == 4);
    }

    private void initComponents() {
        this.withinButtonGroup = new ButtonGroup();
        this.betweenButtonGroup = new ButtonGroup();
        this.unionButton = new JRadioButton();
        this.intersectButton = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.minusButton = new JRadioButton();
        this.differenceButton = new JRadioButton();
        this.okButton = new JButton();
        this.inverseButton = new JRadioButton();
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("Advanced Options");
        this.setResizable(false);
        this.unionButton.setText("Union");
        this.unionButton.setToolTipText("All genes which are expressed in any of the Before/After structures");
        this.unionButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.unionButton.setMargin(new Insets(0, 0, 0, 0));
        this.unionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetailsOptions.this.unionButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.unionButton, new AbsoluteConstraints(190, 10, -1, -1));
        this.intersectButton.setText("Intersection");
        this.intersectButton.setToolTipText("Only those genes which are expressed in all the Before/After structures simultaneously");
        this.intersectButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.intersectButton.setMargin(new Insets(0, 0, 0, 0));
        this.intersectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetailsOptions.this.intersectButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.intersectButton, new AbsoluteConstraints(250, 10, -1, -1));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Within group method");
        this.getContentPane().add((Component)this.jLabel1, new AbsoluteConstraints(10, 10, -1, -1));
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Between group method");
        this.getContentPane().add((Component)this.jLabel2, new AbsoluteConstraints(10, 40, -1, -1));
        this.minusButton.setText("Minus");
        this.minusButton.setToolTipText("All genes which were expressed in the Before structures and not anymore in the After structures");
        this.minusButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.minusButton.setMargin(new Insets(0, 0, 0, 0));
        this.minusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetailsOptions.this.minusButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.minusButton, new AbsoluteConstraints(190, 40, -1, -1));
        this.differenceButton.setText("Difference");
        this.differenceButton.setToolTipText("All genes which changed their expression state in the Before-After process. (i.e. all genes which were first on in the Before structures and then off in the After structures, or vice versa)");
        this.differenceButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.differenceButton.setMargin(new Insets(0, 0, 0, 0));
        this.differenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetailsOptions.this.differenceButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.differenceButton, new AbsoluteConstraints(250, 40, -1, -1));
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetailsOptions.this.okButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.okButton, new AbsoluteConstraints(390, 70, -1, -1));
        this.inverseButton.setText("Inverse Minus");
        this.inverseButton.setToolTipText("All genes which were not expressed in the Before structures and are expressed in the After structures");
        this.inverseButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.inverseButton.setMargin(new Insets(0, 0, 0, 0));
        this.inverseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetailsOptions.this.inverseButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.inverseButton, new AbsoluteConstraints(340, 40, -1, -1));
        this.pack();
    }

    private void inverseButtonActionPerformed(ActionEvent evt) {
        this.parent.dataset.setDifferenceMethod((byte)4);
        this.parent.refresh();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void differenceButtonActionPerformed(ActionEvent evt) {
        this.parent.dataset.setDifferenceMethod((byte)3);
        this.parent.refresh();
    }

    private void minusButtonActionPerformed(ActionEvent evt) {
        this.parent.dataset.setDifferenceMethod((byte)2);
        this.parent.refresh();
    }

    private void intersectButtonActionPerformed(ActionEvent evt) {
        this.parent.dataset.setIntersectionMethod((byte)1);
        this.parent.refresh();
    }

    private void unionButtonActionPerformed(ActionEvent evt) {
        this.parent.dataset.setIntersectionMethod((byte)0);
        this.parent.refresh();
    }
}

