/*
 * Decompiled with CFR 0.152.
 */
package mousegui15;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import mouse.BeforeAfterCassette;
import mouse.Cassette;
import mouse.Gene;
import mousegui15.DatasetDetailsHelp;
import mousegui15.DatasetDetailsOptions;
import mousegui15.MouseMainWindow;
import mousegui15.TextAreaRenderer;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class DatasetDetails
extends JFrame {
    private MouseMainWindow parent;
    protected BeforeAfterCassette dataset;
    private int index;
    private String filename;
    public static HashMap<Integer, Entry> property_map;
    public static HashMap<Integer, Vector<Integer>> children_map;
    private JPanel CENTER2;
    private JPanel NORTH;
    private JPanel SOUTH;
    private JLabel afterLabel;
    private JLabel beforeLabel;
    private JComboBox cboStage;
    private JButton cmdAdvancedSettings;
    private JButton cmdAfterAdd;
    private JButton cmdAfterMinus;
    private JButton cmdBeforeAdd;
    private JButton cmdBeforeMinus;
    private JButton cmdCancel;
    private JButton cmdOK;
    private JButton cmdRefresh;
    private JButton cmdSwap;
    private JTextArea commentText;
    private JMenuItem displayHelpItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JList geneList;
    private JMenu helpMenu;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    public JLabel lblBetweenGroup;
    public JLabel lblWithinGroup;
    private JMenuBar menuBar;
    private JPanel n_c;
    private JPanel n_e;
    private JPanel n_w;
    private JMenuItem openMenuItem;
    private JRadioButton optProcess;
    private JRadioButton optStructure;
    private ButtonGroup radioButtonGroup;
    private JPanel s1_east;
    private JPanel s1_west;
    private JPanel s_c;
    private JPanel s_n;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JPanel south1;
    private JTable tblAfter;
    private JTable tblBefore;
    private JTree treeStructures;
    private JTextField txtName;

    public static Cassette getCassetteFromDB(String structure_key, String structure_name, String label, String user, String pwd) {
        try {
            Class.forName("com.sybase.jdbc3.jdbc.SybDriver");
            Connection con = DriverManager.getConnection("jdbc:sybase:Tds:gondor.informatics.jax.org:4025", user, pwd);
            Statement stmt = con.createStatement();
            String[] structure_keys = structure_key.split(",");
            Cassette result = new Cassette(label, structure_name);
            Vector<Integer> query_nodes = new Vector<Integer>();
            for (int i = 0; i < structure_keys.length; ++i) {
                try {
                    int key = Integer.parseInt(structure_keys[i]);
                    if (query_nodes.contains(key)) continue;
                    query_nodes.add(key);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            while (query_nodes.size() > 0) {
                System.out.println("Processing " + query_nodes.get(0));
                String query = "SELECT MAX(a.accID) FROM MRK_Mouse_View m, ACC_Accession a, GXD_Expression e, GXD_Structure s WHERE m._Marker_key = a._Object_key AND a._MGIType_key = 2 AND a._LogicalDB_key in (13, 41, 1) AND a.preferred = 1 AND a._Object_key = e._Marker_key AND e.expressed = 1 AND e._Structure_key = s._Structure_key AND s._Structure_key = " + query_nodes.get(0) + " " + "AND not exists (SELECT 1 from GXD_AlleleGenotype g where e._Genotype_key = g._Genotype_key) " + "GROUP BY a._Object_key";
                ResultSet rs = stmt.executeQuery(query);
                Vector<Integer> children = children_map.get(query_nodes.get(0));
                query_nodes.remove(0);
                if (children != null) {
                    query_nodes.addAll(children);
                }
                boolean index = false;
                while (rs.next()) {
                    Gene current = new Gene(rs.getString(1));
                    result.add(current);
                }
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createMaps(String usr, String pwd) {
        try {
            property_map = new HashMap();
            children_map = new HashMap();
            Class.forName("com.sybase.jdbc3.jdbc.SybDriver");
            Connection con = DriverManager.getConnection("jdbc:sybase:Tds:gondor.informatics.jax.org:4025", usr, pwd);
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT _Structure_key, _Parent_key, printName, edinburghKey FROM GXD_Structure");
            while (rs.next()) {
                property_map.put(rs.getInt(1), new Entry(rs.getInt(1), rs.getString(3), rs.getInt(4)));
                Vector<Integer> v = children_map.get(rs.getInt(2));
                if (v == null) {
                    v = new Vector();
                }
                v.add(rs.getInt(1));
                children_map.put(rs.getInt(2), v);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DefaultMutableTreeNode recursivelyPopulate(int key) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(property_map.get(key));
        Vector<Integer> children = children_map.get(key);
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                root.add(DatasetDetails.recursivelyPopulate(children.get(i)));
            }
        }
        return root;
    }

    public static DefaultComboBoxModel createSelectBoxOptions() {
        Entry[] options = new Entry[27];
        options[0] = new Entry(0, "PLEASE SELECT A THEILER STAGE");
        for (int i = 1; i < 27; ++i) {
            options[i] = new Entry(i, "Theiler Stage " + i);
        }
        return new DefaultComboBoxModel<Entry>(options);
    }

    public DatasetDetails(MouseMainWindow parent, BeforeAfterCassette dataset, int index) {
        this.parent = parent;
        this.dataset = dataset == null ? new BeforeAfterCassette("") : dataset.clone();
        this.index = index;
        if (property_map == null) {
            DatasetDetails.createMaps(parent.user, parent.pwd);
        }
        this.initComponents();
        parent.setEnabled(false);
        parent.getContentPane().setEnabled(false);
        this.treeStructures.getSelectionModel().setSelectionMode(1);
        this.radioButtonGroup.add(this.optProcess);
        this.radioButtonGroup.add(this.optStructure);
        this.tblBefore.getColumn("Stage").setPreferredWidth(10);
        this.tblBefore.getColumn("Structure Name").setPreferredWidth(250);
        this.tblBefore.getColumn("Size").setPreferredWidth(10);
        this.tblAfter.getColumn("Stage").setPreferredWidth(10);
        this.tblAfter.getColumn("Structure Name").setPreferredWidth(250);
        this.tblAfter.getColumn("Size").setPreferredWidth(10);
        this.tblBefore.getColumnModel().getColumn(1).setCellRenderer(new TextAreaRenderer());
        this.tblAfter.getColumnModel().getColumn(1).setCellRenderer(new TextAreaRenderer());
        this.refresh();
    }

    protected void refresh() {
        int i;
        this.dataset.refresh();
        this.txtName.setText(this.dataset.getLabel());
        if (this.dataset.isTemporal()) {
            this.beforeLabel.setText("Before");
            this.afterLabel.setVisible(true);
            this.tblAfter.setVisible(true);
            this.tblAfter.setEnabled(true);
            this.cmdAfterAdd.setVisible(true);
            this.cmdAfterMinus.setVisible(true);
        } else {
            this.beforeLabel.setText("Tissues");
            this.afterLabel.setVisible(false);
            this.tblAfter.setVisible(false);
            this.tblAfter.setEnabled(false);
            this.cmdAfterAdd.setVisible(false);
            this.cmdAfterMinus.setVisible(false);
        }
        this.cmdSwap.setEnabled(this.dataset.isTemporal());
        this.optProcess.setSelected(this.dataset.isTemporal());
        this.optStructure.setSelected(!this.dataset.isTemporal());
        this.commentText.setText(this.dataset.getComment());
        if (this.dataset.getDifferenceMethod() == 3) {
            this.lblBetweenGroup.setText("Difference");
        } else if (this.dataset.getDifferenceMethod() == 2) {
            this.lblBetweenGroup.setText("Minus");
        } else {
            this.lblBetweenGroup.setText("Inverse Minus");
        }
        if (this.dataset.getIntersectionMethod() == 1) {
            this.lblWithinGroup.setText("Intersection");
        } else {
            this.lblWithinGroup.setText("Union");
        }
        DefaultTableModel model = (DefaultTableModel)this.tblBefore.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
        for (i = 0; i < this.dataset.before.size(); ++i) {
            model.addRow(new Object[]{this.dataset.before.get((int)i).stage, this.dataset.before.get((int)i).label, this.dataset.before.get(i).size()});
        }
        model = (DefaultTableModel)this.tblAfter.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
        for (i = 0; i < this.dataset.after.size(); ++i) {
            model.addRow(new Object[]{this.dataset.after.get((int)i).stage, this.dataset.after.get((int)i).label, this.dataset.after.get(i).size()});
        }
        DefaultListModel<Gene> listModel = new DefaultListModel<Gene>();
        for (int i2 = 0; i2 < this.dataset.size(); ++i2) {
            listModel.addElement(this.dataset.get(i2));
        }
        this.geneList.setModel(listModel);
    }

    private void initComponents() {
        this.radioButtonGroup = new ButtonGroup();
        this.NORTH = new JPanel();
        this.n_c = new JPanel();
        this.optProcess = new JRadioButton();
        this.optStructure = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.n_e = new JPanel();
        this.cmdAdvancedSettings = new JButton();
        this.n_w = new JPanel();
        this.jLabel3 = new JLabel();
        this.txtName = new JTextField();
        this.CENTER2 = new JPanel();
        this.cboStage = new JComboBox();
        this.beforeLabel = new JLabel();
        this.cmdBeforeAdd = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.tblBefore = new JTable();
        this.jScrollPane1 = new JScrollPane();
        this.treeStructures = new JTree();
        this.cmdAfterAdd = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.tblAfter = new JTable();
        this.afterLabel = new JLabel();
        this.cmdBeforeMinus = new JButton();
        this.cmdAfterMinus = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.geneList = new JList();
        this.jLabel5 = new JLabel();
        this.SOUTH = new JPanel();
        this.s_c = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.commentText = new JTextArea();
        this.s_n = new JPanel();
        this.jLabel6 = new JLabel();
        this.south1 = new JPanel();
        this.s1_east = new JPanel();
        this.cmdSwap = new JButton();
        this.cmdRefresh = new JButton();
        this.cmdOK = new JButton();
        this.cmdCancel = new JButton();
        this.s1_west = new JPanel();
        this.lblWithinGroup = new JLabel();
        this.jLabel1 = new JLabel();
        this.lblBetweenGroup = new JLabel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.displayHelpItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("Dataset Details");
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                DatasetDetails.this.formWindowClosed(evt);
            }
        });
        this.NORTH.setLayout(new BorderLayout());
        this.n_c.setLayout(new FlowLayout(2));
        this.optProcess.setText("Process");
        this.optProcess.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optProcess.setMargin(new Insets(0, 0, 0, 0));
        this.optProcess.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.optProcessActionPerformed(evt);
            }
        });
        this.n_c.add(this.optProcess);
        this.optStructure.setText("Structure");
        this.optStructure.setToolTipText("");
        this.optStructure.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optStructure.setMargin(new Insets(0, 0, 0, 0));
        this.optStructure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.optStructureActionPerformed(evt);
            }
        });
        this.n_c.add(this.optStructure);
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Type");
        this.n_c.add(this.jLabel4);
        this.NORTH.add((Component)this.n_c, "Center");
        this.n_e.setLayout(new FlowLayout(2));
        this.cmdAdvancedSettings.setText("Advanced Settings");
        this.cmdAdvancedSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.cmdAdvancedSettingsActionPerformed(evt);
            }
        });
        this.n_e.add(this.cmdAdvancedSettings);
        this.NORTH.add((Component)this.n_e, "East");
        this.n_w.setLayout(new FlowLayout(0));
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Cassette Name");
        this.n_w.add(this.jLabel3);
        this.txtName.setColumns(32);
        this.txtName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.txtNameActionPerformed(evt);
            }
        });
        this.txtName.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                DatasetDetails.this.txtNameFocusLost(evt);
            }
        });
        this.n_w.add(this.txtName);
        this.NORTH.add((Component)this.n_w, "West");
        this.getContentPane().add((Component)this.NORTH, "North");
        this.CENTER2.setLayout(new AbsoluteLayout());
        this.CENTER2.setBorder(BorderFactory.createEtchedBorder());
        this.cboStage.setModel(DatasetDetails.createSelectBoxOptions());
        this.cboStage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.cboStageActionPerformed(evt);
            }
        });
        this.CENTER2.add((Component)this.cboStage, new AbsoluteConstraints(10, 10, 300, -1));
        this.beforeLabel.setFont(new Font("Tahoma", 1, 11));
        this.beforeLabel.setText("Before");
        this.CENTER2.add((Component)this.beforeLabel, new AbsoluteConstraints(430, 0, -1, -1));
        this.cmdBeforeAdd.setText(">");
        this.cmdBeforeAdd.setEnabled(false);
        this.cmdBeforeAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.cmdBeforeAddActionPerformed(evt);
            }
        });
        this.CENTER2.add((Component)this.cmdBeforeAdd, new AbsoluteConstraints(320, 50, -1, -1));
        this.tblBefore.setModel(new DefaultTableModel(new Object[0][], new String[]{"Stage", "Structure Name", "Size"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.tblBefore);
        this.CENTER2.add((Component)this.jScrollPane2, new AbsoluteConstraints(430, 20, 490, 120));
        this.treeStructures.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(new Entry(0, ""))));
        this.treeStructures.setRootVisible(false);
        this.treeStructures.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                DatasetDetails.this.treeStructuresValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.treeStructures);
        this.CENTER2.add((Component)this.jScrollPane1, new AbsoluteConstraints(10, 40, 300, 240));
        this.cmdAfterAdd.setText(">");
        this.cmdAfterAdd.setEnabled(false);
        this.cmdAfterAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.cmdAfterAddActionPerformed(evt);
            }
        });
        this.CENTER2.add((Component)this.cmdAfterAdd, new AbsoluteConstraints(320, 210, -1, -1));
        this.tblAfter.setModel(new DefaultTableModel(new Object[0][], new String[]{"Stage", "Structure Name", "Size"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane3.setViewportView(this.tblAfter);
        this.CENTER2.add((Component)this.jScrollPane3, new AbsoluteConstraints(430, 160, 490, 120));
        this.afterLabel.setFont(new Font("Tahoma", 1, 11));
        this.afterLabel.setText("After");
        this.CENTER2.add((Component)this.afterLabel, new AbsoluteConstraints(430, 140, -1, -1));
        this.cmdBeforeMinus.setText("<");
        this.cmdBeforeMinus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.cmdBeforeMinusActionPerformed(evt);
            }
        });
        this.CENTER2.add((Component)this.cmdBeforeMinus, new AbsoluteConstraints(320, 80, -1, -1));
        this.cmdAfterMinus.setText("<");
        this.cmdAfterMinus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.cmdAfterMinusActionPerformed(evt);
            }
        });
        this.CENTER2.add((Component)this.cmdAfterMinus, new AbsoluteConstraints(320, 240, -1, -1));
        this.geneList.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.jScrollPane4.setViewportView(this.geneList);
        this.CENTER2.add((Component)this.jScrollPane4, new AbsoluteConstraints(930, 20, 120, 260));
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("Contains");
        this.CENTER2.add((Component)this.jLabel5, new AbsoluteConstraints(930, 0, -1, -1));
        this.getContentPane().add((Component)this.CENTER2, "Center");
        this.SOUTH.setLayout(new BorderLayout());
        this.s_c.setLayout(new FlowLayout(0));
        this.commentText.setColumns(128);
        this.commentText.setRows(4);
        this.commentText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                DatasetDetails.this.commentTextFocusLost(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.commentText);
        this.s_c.add(this.jScrollPane5);
        this.SOUTH.add((Component)this.s_c, "Center");
        this.s_n.setLayout(new FlowLayout(0));
        this.jLabel6.setText("Comment");
        this.s_n.add(this.jLabel6);
        this.SOUTH.add((Component)this.s_n, "North");
        this.south1.setLayout(new BorderLayout());
        this.cmdSwap.setText("Swap Before/After");
        this.cmdSwap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.cmdSwapActionPerformed(evt);
            }
        });
        this.s1_east.add(this.cmdSwap);
        this.cmdRefresh.setText("Refresh from DB");
        this.cmdRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.cmdRefreshActionPerformed(evt);
            }
        });
        this.s1_east.add(this.cmdRefresh);
        this.cmdOK.setText("Add");
        this.cmdOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.cmdOKActionPerformed(evt);
            }
        });
        this.s1_east.add(this.cmdOK);
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.cmdCancelActionPerformed(evt);
            }
        });
        this.s1_east.add(this.cmdCancel);
        this.south1.add((Component)this.s1_east, "East");
        this.lblWithinGroup.setFont(new Font("Tahoma", 0, 10));
        this.lblWithinGroup.setText("jLabel1");
        this.s1_west.add(this.lblWithinGroup);
        this.jLabel1.setText("/");
        this.s1_west.add(this.jLabel1);
        this.lblBetweenGroup.setFont(new Font("Tahoma", 0, 10));
        this.lblBetweenGroup.setText("jLabel7");
        this.s1_west.add(this.lblBetweenGroup);
        this.south1.add((Component)this.s1_west, "West");
        this.SOUTH.add((Component)this.south1, "South");
        this.getContentPane().add((Component)this.SOUTH, "South");
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText("Save as...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText("Help");
        this.displayHelpItem.setText("Help...");
        this.displayHelpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetDetails.this.displayHelpItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.displayHelpItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void cmdSwapActionPerformed(ActionEvent evt) {
        Vector<Integer> tmpKeys = this.dataset.beforeKeys;
        Vector<Cassette> tmp = this.dataset.before;
        this.dataset.beforeKeys = this.dataset.afterKeys;
        this.dataset.before = this.dataset.after;
        this.dataset.afterKeys = tmpKeys;
        this.dataset.after = tmp;
        this.refresh();
    }

    private void cmdRefreshActionPerformed(ActionEvent evt) {
        Cassette c;
        int i;
        Vector<Integer> beforeKeys = this.dataset.beforeKeys;
        Vector<Integer> afterKeys = this.dataset.afterKeys;
        Vector<Cassette> before = this.dataset.before;
        Vector<Cassette> after = this.dataset.after;
        this.dataset.clear();
        for (i = 0; i < beforeKeys.size(); ++i) {
            c = DatasetDetails.getCassetteFromDB(beforeKeys.get(i).toString(), before.get((int)i).label, before.get((int)i).contents, this.parent.user, this.parent.pwd);
            c.stage = before.get((int)i).stage;
            this.dataset.addBefore(c, beforeKeys.get(i));
        }
        for (i = 0; i < afterKeys.size(); ++i) {
            c = DatasetDetails.getCassetteFromDB(afterKeys.get(i).toString(), after.get((int)i).label, after.get((int)i).contents, this.parent.user, this.parent.pwd);
            c.stage = after.get((int)i).stage;
            this.dataset.addAfter(c, afterKeys.get(i));
        }
        this.refresh();
    }

    protected void refreshCassettesFromDB() {
    }

    private void displayHelpItemActionPerformed(ActionEvent evt) {
        new DatasetDetailsHelp((Frame)this, false).setVisible(true);
    }

    private void formWindowClosed(WindowEvent evt) {
        this.parent.setEnabled(true);
        this.parent.getContentPane().setEnabled(true);
        this.parent.setVisible(true);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("./projects/cassettes/"));
        fc.setMultiSelectionEnabled(false);
        if (fc.showOpenDialog(this) != 0) {
            return;
        }
        this.filename = fc.getSelectedFile().getAbsolutePath();
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.filename));
            this.dataset = (BeforeAfterCassette)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error loading file.", "Load Error", 0);
            this.dataset = new BeforeAfterCassette("");
        }
        this.refresh();
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        this.saveAs(null);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        this.saveAs(this.filename);
    }

    private void saveAs(String fn) {
        if (fn == null) {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File("./projects/cassettes/"));
            fc.setMultiSelectionEnabled(false);
            if (fc.showSaveDialog(this) == 0) {
                this.filename = fc.getSelectedFile().getAbsolutePath();
            } else {
                return;
            }
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.filename));
            oos.writeObject(this.dataset);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.parent.setEnabled(true);
        this.parent.getContentPane().setEnabled(true);
        this.dispose();
    }

    private void cmdOKActionPerformed(ActionEvent evt) {
        if (this.dataset.label.equals("")) {
            JOptionPane.showMessageDialog(this, "Please enter a name for the new dataset.", "Unnamed Dataset", 2);
        } else {
            this.parent.addCassette(this.index, this.dataset);
            ++MouseMainWindow.count;
            this.parent.setEnabled(true);
            this.parent.getContentPane().setEnabled(true);
            this.dispose();
        }
    }

    private void txtNameFocusLost(FocusEvent evt) {
        this.dataset.label = this.txtName.getText();
    }

    private void commentTextFocusLost(FocusEvent evt) {
        this.dataset.setComment(this.commentText.getText());
    }

    private void cmdAdvancedSettingsActionPerformed(ActionEvent evt) {
        DatasetDetailsOptions dialog = new DatasetDetailsOptions(this, true);
        dialog.setLocation(300, 200);
        dialog.setVisible(true);
    }

    private void optStructureActionPerformed(ActionEvent evt) {
        this.dataset.setTemporal(false);
        this.refresh();
    }

    private void optProcessActionPerformed(ActionEvent evt) {
        this.dataset.setTemporal(true);
        this.refresh();
    }

    private void cmdAfterMinusActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.tblAfter.getModel();
        int[] selections = this.tblAfter.getSelectedRows();
        for (int i = 0; i < selections.length; ++i) {
            this.dataset.after.remove(selections[i]);
            this.dataset.afterKeys.remove(selections[i]);
        }
        if (selections.length > 0) {
            this.refresh();
        }
    }

    private void cmdBeforeMinusActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.tblBefore.getModel();
        int[] selections = this.tblBefore.getSelectedRows();
        for (int i = 0; i < selections.length; ++i) {
            this.dataset.before.remove(selections[i]);
            this.dataset.beforeKeys.remove(selections[i]);
        }
        if (selections.length > 0) {
            this.refresh();
        }
    }

    private void cmdAfterAddActionPerformed(ActionEvent evt) {
        Entry selection = (Entry)((DefaultMutableTreeNode)this.treeStructures.getLastSelectedPathComponent()).getUserObject();
        Entry stage = (Entry)this.cboStage.getSelectedItem();
        Cassette c = DatasetDetails.getCassetteFromDB(selection.id + "", "TS" + stage.id + ": " + selection.name, selection.name, this.parent.user, this.parent.pwd);
        c.stage = "TS" + stage.id;
        if (this.dataset.addAfter(c, selection.id)) {
            this.refresh();
        }
    }

    private void cmdBeforeAddActionPerformed(ActionEvent evt) {
        Entry selection = (Entry)((DefaultMutableTreeNode)this.treeStructures.getLastSelectedPathComponent()).getUserObject();
        Entry stage = (Entry)this.cboStage.getSelectedItem();
        Cassette c = DatasetDetails.getCassetteFromDB(selection.id + "", "TS" + stage.id + ": " + selection.name, selection.name, this.parent.user, this.parent.pwd);
        c.stage = "TS" + stage.id;
        if (this.dataset.addBefore(c, selection.id)) {
            this.refresh();
        }
    }

    private void txtNameActionPerformed(ActionEvent evt) {
        this.dataset.label = this.txtName.getText();
    }

    private void treeStructuresValueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeStructures.getLastSelectedPathComponent();
        if (node == null) {
            this.cmdBeforeAdd.setEnabled(false);
            this.cmdAfterAdd.setEnabled(false);
            return;
        }
        this.cmdBeforeAdd.setEnabled(true);
        this.cmdAfterAdd.setEnabled(true);
    }

    private void cboStageActionPerformed(ActionEvent evt) {
        DefaultTreeModel model = (DefaultTreeModel)this.treeStructures.getModel();
        Entry item = (Entry)this.cboStage.getSelectedItem();
        if (item.id != 0) {
            try {
                Class.forName("com.sybase.jdbc3.jdbc.SybDriver");
                Connection con = DriverManager.getConnection("jdbc:sybase:Tds:gondor.informatics.jax.org:4025", this.parent.user, this.parent.pwd);
                Statement stmt = con.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT _Structure_key FROM GXD_Structure WHERE _Stage_key = " + item.id + " AND _Parent_key IS NULL");
                rs.next();
                model.setRoot(DatasetDetails.recursivelyPopulate(rs.getInt(1)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            model.setRoot(null);
        }
        model.reload();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void setBetweenGroupLabel(String name) {
        this.lblBetweenGroup.setText(name);
    }

    public void setWithinGroupLabel(String name) {
        this.lblWithinGroup.setText(name);
    }

    static class Entry {
        String name;
        int id;
        int edbkey;

        public Entry(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public Entry(int id, String name, int edbkey) {
            this.id = id;
            this.name = name;
            this.edbkey = edbkey;
        }

        public String toString() {
            return this.name;
        }
    }
}

