/*
 * Decompiled with CFR 0.152.
 */
package mousegui15;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import mouse.BeforeAfterCassette;
import mouse.Gene;
import mouse.IntersectionCassette;
import mousegui15.ContrastDatasets;

public class ContrastReport
extends JDialog {
    HashMap<BeforeAfterCassette, Integer> map;
    private IntersectionCassette[] datasets;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPanel pnlDistinctDatasets;
    private JTable reportTable;
    private JButton saveButton;

    public ContrastReport(Frame parent, boolean modal, IntersectionCassette[] input) {
        super(parent, modal);
        int i;
        this.initComponents();
        this.datasets = input;
        Vector<BeforeAfterCassette> distinctcassettes = new Vector<BeforeAfterCassette>();
        this.map = new HashMap();
        for (int i2 = 0; i2 < input.length; ++i2) {
            for (int j = 0; j < input[i2].intersected_cassettes.size(); ++j) {
                if (distinctcassettes.contains(input[i2].intersected_cassettes.get(j))) continue;
                distinctcassettes.add(input[i2].intersected_cassettes.get(j));
            }
        }
        int rows = distinctcassettes.size() / 2 + distinctcassettes.size() % 2;
        ((GridLayout)this.pnlDistinctDatasets.getLayout()).setRows(rows);
        ContrastDatasets dummy = new ContrastDatasets((BeforeAfterCassette)distinctcassettes.get(0), 0);
        this.pnlDistinctDatasets.setSize(this.jPanel2.getWidth(), rows * dummy.getHeight());
        for (int i3 = 0; i3 < distinctcassettes.size(); ++i3) {
            this.pnlDistinctDatasets.add(new ContrastDatasets((BeforeAfterCassette)distinctcassettes.get(i3), i3));
            this.map.put((BeforeAfterCassette)distinctcassettes.get(i3), new Integer(i3));
        }
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        DefaultTableModel model = new DefaultTableModel();
        for (i = 0; i < input.length; ++i) {
            String title = "";
            for (int j = 0; j < input[i].intersected_cassettes.size(); ++j) {
                title = title + " " + this.map.get(input[i].intersected_cassettes.get(j));
            }
            model.addColumn((Object)title, input[i].genes.toArray(new Gene[input[i].genes.size()]));
        }
        this.reportTable.setModel(model);
        for (i = 0; i < input.length; ++i) {
            tips.setToolTip(this.reportTable.getColumnModel().getColumn(i), input[i].getLabel());
        }
        JTableHeader header = this.reportTable.getTableHeader();
        header.addMouseMotionListener(tips);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.pnlDistinctDatasets = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.reportTable = new JTable();
        this.saveButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Result Report");
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.pnlDistinctDatasets.setLayout(new GridLayout(1, 2));
        this.pnlDistinctDatasets.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.add(this.pnlDistinctDatasets);
        this.reportTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.reportTable.setCellSelectionEnabled(true);
        this.jScrollPane1.setViewportView(this.reportTable);
        this.jPanel2.add(this.jScrollPane1);
        this.saveButton.setText("Save to Text File");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ContrastReport.this.saveButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.saveButton);
        this.jScrollPane2.setViewportView(this.jPanel2);
        this.getContentPane().add((Component)this.jScrollPane2, "Center");
        this.pack();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("./projects/textfiles/"));
        fc.setMultiSelectionEnabled(false);
        if (fc.showSaveDialog(this) != 0) {
            return;
        }
        String filename = fc.getSelectedFile().getAbsolutePath();
        File filey = new File(filename);
        try {
            PrintWriter printey = new PrintWriter(new FileWriter(filey));
            for (int i = 0; i < this.datasets.length; ++i) {
                printey.println("Intersection Results for " + this.datasets[i].getLabel());
                printey.println();
                printey.println("Original Structures:");
                printey.println();
                for (int j = 0; j < this.datasets[i].intersected_cassettes.size(); ++j) {
                    printey.println("Name: " + this.datasets[i].intersected_cassettes.get(j).getLabel());
                    printey.println("Before: " + this.datasets[i].intersected_cassettes.get(j).toStringBefore());
                    printey.println("After: " + this.datasets[i].intersected_cassettes.get(j).toStringAfter());
                    printey.println();
                }
                printey.println("List of genes:");
                printey.println("-----------------------------------");
                for (int m = 0; m < this.datasets[i].genes.size(); ++m) {
                    printey.println(((Gene)this.datasets[i].genes.get(m)).toString());
                }
                printey.println();
                printey.println("====================================================================");
            }
            printey.flush();
            printey.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteRowButtonActionPerformed(ActionEvent evt) {
    }

    public class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map tips = new HashMap();

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        public void mouseMoved(MouseEvent evt) {
            TableColumn col = null;
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            if (vColIndex >= 0) {
                col = colModel.getColumn(vColIndex);
            }
            if (col != this.curCol) {
                header.setToolTipText((String)this.tips.get(col));
                this.curCol = col;
            }
        }
    }
}

