/*
 * Decompiled with CFR 0.152.
 */
package mouse;

import com.sybase.jdbc3.jdbc.SybDriver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import mouse.Cassette;
import mouse.Gene;
import mouse.IntersectionSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));

    public static void closeResultSet(ResultSet rst) {
        try {
            rst.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeConnection(Connection in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error closing database connection.");
        }
    }

    public static void closeStatement(Statement stat) {
        try {
            stat.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closePreparedStatement(PreparedStatement stat) {
        Main.closeStatement(stat);
    }

    public static Connection establishConnection(String url, String username, String password) {
        Connection con = null;
        try {
            SybDriver driver = (SybDriver)Class.forName("com.sybase.jdbc3.jdbc.SybDriver").newInstance();
            con = DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("JDBC connection failed.");
        }
        return con;
    }

    public static void main(String[] args) throws Exception {
        int i;
        int counter = 0;
        int another = 89;
        boolean dataexists = false;
        boolean inputvalid = false;
        Vector<String> datasets = new Vector<String>();
        Vector<String> tissuelabel = new Vector<String>();
        Vector<String> stagelabel = new Vector<String>();
        Vector<Object> permutations = new Vector();
        Connection con = Main.establishConnection("jdbc:sybase:Tds:gondor.informatics.jax.org:4025", "saitken", "SAitk3n01");
        while (another == 89 || another == 121) {
            System.out.println("Please enter dataset:");
            String dataset = stdin.readLine();
            try {
                int intValid = Integer.parseInt(dataset.trim());
                inputvalid = true;
            }
            catch (NumberFormatException nfe) {
                System.out.println("The dataset you entered must be an integer.");
                inputvalid = false;
            }
            if (inputvalid) {
                PreparedStatement query = con.prepareStatement("SELECT printName, _Stage_key FROM GXD_Structure WHERE edinburghKey = " + dataset + "");
                ResultSet results = query.executeQuery();
                if (results.next()) {
                    datasets.add(dataset);
                    tissuelabel.add(results.getString(1));
                    stagelabel.add(results.getString(2));
                    System.out.println("You have " + ++counter + " dataset(s) in the list.");
                    int i2 = 0;
                    for (i2 = 0; i2 < counter; ++i2) {
                        System.out.println(i2 + 1 + ". " + (String)datasets.get(i2) + " : " + (String)tissuelabel.get(i2) + ", Stage " + (String)stagelabel.get(i2));
                    }
                } else {
                    System.out.println("The dataset you have entered is not valid.");
                }
            }
            System.out.println("Do you wish to enter another dataset? Y/N");
            another = (char)System.in.read();
            System.in.read();
        }
        Cassette[] genelists = new Cassette[counter];
        for (int k = 0; k < counter; ++k) {
            genelists[k] = new Cassette((String)datasets.get(k));
            PreparedStatement query = con.prepareStatement("SELECT distinct ac.accID FROM ACC_Accession ac, GXD_Expression e,GXD_Structure s  WHERE ac._MGIType_key = 2 AND  ac._LogicalDB_key = 1 AND  ac.preferred = 1 AND  ac.prefixPart = 'MGI:' AND ac._Object_key = e._Marker_key AND e.expressed = 1 AND e._Structure_key = s._Structure_key AND s.edinburghKey = " + (String)datasets.get(k) + " " + "AND not exists (SELECT 1 from GXD_AlleleGenotype g where e._Genotype_key = g._Genotype_key)");
            ResultSet result = query.executeQuery();
            while (result.next()) {
                genelists[k].add(new Gene(result.getString(1)));
            }
            System.out.println(genelists[k].label);
            for (int i3 = 0; i3 < genelists[k].size(); ++i3) {
                System.out.println(genelists[k].get(i3));
            }
        }
        System.out.println("Final list of datasets:");
        for (int j = 0; j < counter; ++j) {
            System.out.println(j + 1 + ". Dataset " + (String)datasets.get(j) + " contains " + genelists[j].size() + " genes.");
        }
        another = 78;
        System.out.println("Do you wish to calculate all possible intersection permutations now? (Y/N)");
        another = (char)System.in.read();
        System.in.read();
        if (another == 89 || another == 121) {
            System.out.println("List of intersection permutations:");
            permutations = IntersectionSet.findCombinations(genelists);
            for (i = 0; i < permutations.size(); ++i) {
                System.out.println("------" + (permutations.size() - i + 1) + "------");
                for (int j = 0; j < ((Vector[])permutations.get(i)).length; ++j) {
                    for (int k = 0; k < ((Vector[])permutations.get(i))[j].size(); ++k) {
                        System.out.print(genelists[((Integer)((Vector[])permutations.get((int)i))[j].get((int)k)).intValue()].label);
                    }
                    System.out.println();
                }
                System.out.println("-------------");
            }
        } else {
            System.out.println("Exiting program...");
        }
        if (another == 89 || another == 121) {
            another = 78;
            System.out.println("Do you wish to perform the intersections now? (Y/N)");
            another = (char)System.in.read();
            System.in.read();
            if (another == 89 || another == 121) {
                for (i = 0; i < permutations.size(); ++i) {
                    for (int j = 0; j < ((Vector[])permutations.get(i)).length; ++j) {
                        String permie = Main.permutationString(genelists, permutations, i, j);
                        System.out.println("Do you want to perform an intersection on: " + permie + " ? (Y/N)");
                        another = 78;
                        another = (char)System.in.read();
                        System.in.read();
                        if (another != 89 && another != 121) continue;
                        Cassette intersectResult = genelists[(Integer)((Vector[])permutations.get(i))[j].get(0)];
                        for (int k = 0; k < ((Vector[])permutations.get(i))[j].size(); ++k) {
                            intersectResult = intersectResult.intersectWith(genelists[(Integer)((Vector[])permutations.get(i))[j].get(k)]);
                        }
                        System.out.println(intersectResult);
                        System.out.println("Would you like to save this result in a text file? (Y/N)");
                        another = 78;
                        another = (char)System.in.read();
                        System.in.read();
                        if (another != 89 && another != 121) continue;
                        File filey = new File("permie" + permie + ".txt");
                        PrintWriter printey = new PrintWriter(new FileWriter(filey));
                        printey.println("Intersection Results for " + permie);
                        printey.println("-----------------------------------");
                        for (int m = 0; m < intersectResult.size(); ++m) {
                            printey.println(intersectResult.get(m));
                        }
                        printey.flush();
                        printey.close();
                    }
                }
            } else {
                System.out.println("Exiting program...");
            }
        }
    }

    public static String permutationString(Cassette[] set, Vector<Vector<Integer>[]> permutations, int K, int I) {
        String output = "";
        for (int n = 0; n < permutations.get(K)[I].size(); ++n) {
            output = output + set[permutations.get((int)K)[I].get((int)n).intValue()].label + "-";
        }
        return output;
    }

    public static void test() {
    }
}

