/*
 * Decompiled with CFR 0.152.
 */
package mouse;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;
import mouse.BeforeAfterCassette;
import mouse.Cassette;
import mouse.IntersectionCassette;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectionSet
implements Serializable {
    public static final long serialVersionUID = 20070729L;
    public IntersectionCassette[][] intersections;
    int N;

    public IntersectionSet(int N) {
        this.N = N;
        this.intersections = new IntersectionCassette[N - 1][];
        for (int n = N; n > 1; --n) {
            int size = IntersectionSet.binomial(n, N);
            this.intersections[N - n] = new IntersectionCassette[size];
        }
    }

    static int binomial(int k, int n) {
        int x = IntersectionSet.factorial(n) / (IntersectionSet.factorial(k) * IntersectionSet.factorial(n - k));
        return x;
    }

    static int factorial(int n) {
        if (n <= 1) {
            return 1;
        }
        return n * IntersectionSet.factorial(n - 1);
    }

    public void printContents() {
        for (int i = 0; i < this.intersections.length; ++i) {
            System.out.println("Intersections with " + (this.N - i) + " tissues:");
            System.out.println(Arrays.deepToString(this.intersections[i]));
        }
    }

    public void calculateIntersections(BeforeAfterCassette[] input) {
        Vector<Vector<Integer>[]> permutations = IntersectionSet.findCombinations(input);
        for (int i = 0; i < this.intersections.length; ++i) {
            for (int j = 0; j < this.intersections[i].length; ++j) {
                Vector<Integer> current_permutation = permutations.get(i)[j];
                this.intersections[i][j] = new IntersectionCassette("");
                for (int k = 0; k < current_permutation.size(); ++k) {
                    this.intersections[i][j].addIntersectedCassette(input[current_permutation.get(k)]);
                }
            }
        }
    }

    static Vector<Vector<Integer>[]> findCombinations(Cassette[] set) {
        Vector<Vector<Integer>[]> results = new Vector<Vector<Integer>[]>();
        for (int i = set.length; i >= 2; --i) {
            int size = IntersectionSet.binomial(i, set.length);
            Vector[] combinations = new Vector[size];
            for (int j = 0; j < size; ++j) {
                combinations[j] = new Vector();
            }
            Random randy = new Random();
            randy.setSeed(System.currentTimeMillis());
            Vector<Integer> permutation = new Vector<Integer>();
            int m = 0;
            int k = 0;
            while (m < size) {
                k = 0;
                permutation = new Vector();
                while (k < i) {
                    int selectSet = randy.nextInt(set.length);
                    if (permutation.contains(selectSet)) continue;
                    permutation.add(selectSet);
                    ++k;
                }
                boolean exists = false;
                for (int n = 0; n < m && !exists; ++n) {
                    boolean allin = true;
                    for (int p = 0; p < permutation.size() && allin; ++p) {
                        if (combinations[n].contains(permutation.get(p))) continue;
                        allin = false;
                    }
                    if (!allin) continue;
                    exists = true;
                }
                if (exists) continue;
                combinations[m++] = permutation;
            }
            results.add(combinations);
        }
        return results;
    }
}

