/*
 * Decompiled with CFR 0.152.
 */
package mouse;

import java.io.Serializable;
import java.util.Vector;
import mouse.Gene;

public class Cassette
implements Serializable {
    public static final long serialVersionUID = 20070729L;
    public Vector<Gene> genes;
    public String label;
    public String contents;
    public String stage;

    public Cassette(String label, String contents) {
        this.label = label;
        this.contents = contents;
        this.genes = new Vector();
    }

    public Cassette(String contents) {
        this(contents, contents);
    }

    public Cassette clone() {
        Cassette result = new Cassette(this.label, this.contents);
        for (int i = 0; i < this.size(); ++i) {
            result.add(this.get(i));
        }
        result.stage = this.stage;
        return result;
    }

    public Cassette intersectWith(Cassette a) {
        Cassette result = new Cassette("(" + this.label + ") INTER (" + a.label + ")", "(" + this.contents + ") INTER (" + a.contents + ")");
        for (int i = 0; i < a.size(); ++i) {
            Gene current_gene = a.get(i);
            if (!this.genes.contains(current_gene)) continue;
            result.add(current_gene);
        }
        return result;
    }

    public Gene get(int index) {
        return this.genes.get(index);
    }

    public void add(Gene g) {
        if (!this.genes.contains(g)) {
            this.genes.add(g);
        }
    }

    public int size() {
        return this.genes.size();
    }

    public String toString() {
        String result = this.label + " [";
        for (int i = 0; i < this.size(); ++i) {
            result = result + this.get(i).toString() + " ";
        }
        return result + "]";
    }

    public String getLabel() {
        return this.label;
    }

    public String getGenes() {
        String result = "";
        for (int i = 0; i < this.size(); ++i) {
            result = result + this.get(i).toString() + " ";
        }
        return result;
    }

    public Cassette unionWith(Cassette a) {
        Cassette result = new Cassette("(" + this.label + ") UNION (" + a.label + ")", "(" + this.contents + ") UNION (" + a.contents + ")");
        for (int i = 0; i < this.genes.size(); ++i) {
            result.add(this.genes.get(i));
        }
        for (int i = 0; i < a.size(); ++i) {
            Gene current_gene = a.get(i);
            if (this.genes.contains(current_gene)) continue;
            result.add(a.get(i));
        }
        return result;
    }

    public Cassette difference(Cassette a) {
        int i;
        Cassette result = new Cassette("(" + this.label + ") DIFF (" + a.label + ")", "(" + this.contents + ") DIFF (" + a.contents + ")");
        for (i = 0; i < this.size(); ++i) {
            if (a.genes.contains(this.get(i))) continue;
            result.add(this.get(i));
        }
        for (i = 0; i < a.size(); ++i) {
            if (this.genes.contains(a.get(i))) continue;
            result.add(a.get(i));
        }
        return result;
    }

    public Cassette minus(Cassette a) {
        Cassette result = new Cassette("(" + this.label + ") MINUS (" + a.label + ")", "(" + this.contents + ") MINUS (" + a.contents + ")");
        for (int i = 0; i < this.size(); ++i) {
            if (a.genes.contains(this.get(i))) continue;
            result.add(this.get(i));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof Cassette) {
            Cassette c = (Cassette)o;
            return c.getLabel().equals(this.getLabel()) && c.stage.equals(this.stage);
        }
        return false;
    }
}

