/*
 * Decompiled with CFR 0.152.
 */
package mouse;

import java.util.Vector;
import mouse.Cassette;
import mouse.IntersectionCassette;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeforeAfterCassette
extends Cassette {
    public static final long serialVersionUID = 20070729L;
    public Vector<Cassette> before;
    public Vector<Cassette> after;
    public Vector<Integer> beforeKeys;
    public Vector<Integer> afterKeys;
    private byte intersection_method = 0;
    private byte difference_method = (byte)2;
    public static final byte UNION = 0;
    public static final byte INTERSECTION = 1;
    public static final byte MINUS = 2;
    public static final byte DIFFERENCE = 3;
    public static final byte INVERSEMINUS = 4;
    private boolean is_temporal;
    private String comment = "";

    public BeforeAfterCassette(String contents, String label, boolean temporal) {
        super(contents, label);
        this.is_temporal = temporal;
        this.clear();
        this.refresh();
    }

    public BeforeAfterCassette(String contents, String label) {
        this(contents, label, true);
    }

    public BeforeAfterCassette(String contents) {
        this(contents, contents);
    }

    @Override
    public BeforeAfterCassette clone() {
        int i;
        BeforeAfterCassette result = new BeforeAfterCassette(this.label, this.contents, this.isTemporal());
        for (i = 0; i < this.before.size(); ++i) {
            result.addBefore(this.before.get(i).clone(), this.beforeKeys.get(i));
        }
        for (i = 0; i < this.after.size(); ++i) {
            result.addAfter(this.after.get(i).clone(), this.afterKeys.get(i));
        }
        result.setDifferenceMethod(this.getDifferenceMethod());
        result.setIntersectionMethod(this.getIntersectionMethod());
        result.refresh();
        return result;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String s) {
        this.comment = s;
    }

    public void setTemporal(boolean process) {
        this.is_temporal = process;
        if (!process) {
            this.after = new Vector();
            this.afterKeys = new Vector();
        }
    }

    public void setIntersectionMethod(byte method) {
        this.intersection_method = method;
    }

    public byte getIntersectionMethod() {
        return this.intersection_method;
    }

    public byte getDifferenceMethod() {
        return this.difference_method;
    }

    public void setDifferenceMethod(byte method) {
        this.difference_method = method;
    }

    public boolean addBefore(Cassette c, Integer s) {
        if (!this.beforeKeys.contains(s)) {
            this.before.add(c);
            this.beforeKeys.add(s);
            return true;
        }
        return false;
    }

    public void clear() {
        this.before = new Vector();
        this.beforeKeys = new Vector();
        this.after = new Vector();
        this.afterKeys = new Vector();
        this.genes = new Vector();
    }

    public void removeBefore(String s) {
        for (int i = 0; i < this.before.size(); ++i) {
            if (!this.before.get(i).getLabel().equals(s)) continue;
            this.before.remove(i);
            this.beforeKeys.remove(i);
            break;
        }
    }

    public void removeBefore(Cassette c) {
        this.removeBefore(c.getLabel());
    }

    public void removeAfter(String s) {
        for (int i = 0; i < this.after.size(); ++i) {
            if (!this.after.get(i).getLabel().equals(s)) continue;
            this.after.remove(i);
            this.afterKeys.remove(i);
            break;
        }
    }

    public void removeAfter(Cassette c) {
        this.removeAfter(c.getLabel());
    }

    public boolean addAfter(Cassette c, Integer s) {
        if (!this.afterKeys.contains(s)) {
            this.after.add(c);
            this.afterKeys.add(s);
            return true;
        }
        return false;
    }

    public Vector<Cassette> getBefore() {
        return this.before;
    }

    public Vector<Cassette> getAfter() {
        return this.after;
    }

    public boolean isTemporal() {
        return this.is_temporal;
    }

    public void refresh() {
        this.genes = new Vector();
        if (this.before.size() > 0) {
            Cassette before_union = this.before.get(0);
            block13: for (int i = 1; i < this.before.size(); ++i) {
                Cassette current = this.before.get(i);
                switch (this.intersection_method) {
                    case 0: {
                        before_union = before_union.unionWith(current);
                        continue block13;
                    }
                    case 1: {
                        before_union = before_union.intersectWith(current);
                        continue block13;
                    }
                    default: {
                        throw new RuntimeException("Illegal intersection method selected: " + this.intersection_method);
                    }
                }
            }
            if (this.after.size() > 0) {
                Cassette after_union = this.after.get(0);
                block14: for (int i = 1; i < this.after.size(); ++i) {
                    Cassette current = this.after.get(i);
                    switch (this.intersection_method) {
                        case 0: {
                            after_union = after_union.unionWith(current);
                            continue block14;
                        }
                        case 1: {
                            after_union = after_union.intersectWith(current);
                            continue block14;
                        }
                        default: {
                            throw new RuntimeException("Illegal intersection method selected: " + this.intersection_method);
                        }
                    }
                }
                switch (this.difference_method) {
                    case 2: {
                        before_union = before_union.minus(after_union);
                        break;
                    }
                    case 3: {
                        before_union = before_union.difference(after_union);
                        break;
                    }
                    case 4: {
                        before_union = after_union.minus(before_union);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Illegal difference method selected: " + this.difference_method);
                    }
                }
            }
            this.genes = before_union.genes;
            this.contents = before_union.contents;
        }
    }

    public IntersectionCassette intersectWith(BeforeAfterCassette c) {
        IntersectionCassette result = new IntersectionCassette("(" + this.label + ") INTER (" + c.label + ")", "(" + this.contents + ") INTER (" + c.contents + ")");
        result.addIntersectedCassette(this);
        result.addIntersectedCassette(c);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BeforeAfterCassette) {
            BeforeAfterCassette b = (BeforeAfterCassette)o;
            return b.getLabel().equals(this.getLabel());
        }
        return false;
    }

    public String toStringBefore() {
        String result = "";
        for (int i = 0; i < this.before.size(); ++i) {
            result = result + this.before.get(i).getLabel() + ",";
        }
        return result;
    }

    public String toStringAfter() {
        String result = "";
        for (int i = 0; i < this.after.size(); ++i) {
            result = result + this.after.get(i).getLabel() + ",";
        }
        return result;
    }

    @Override
    public String toString() {
        String result = "Name: " + this.label + "\n";
        result = result + "Before: " + this.toStringBefore() + "\nAfter: " + this.toStringAfter();
        return result;
    }
}

